/*
  Auswerter für Datenlogger mit ESP32
   Analogeingänge 0..7 entsprechen Kanälen 1..8

   Kommunikation über Seriell

   1..8 [CR]
   entsprechender Kanal 1...8 wird ausgelesen und übergeben
   A[CR] oder a[CR]
   alle Kanäler werden audsgeleden und übergeben

  R[CR] oder r[CR]
  Reset oder Restart
  gibt aus:
   START [CR][LF]
   HEAD  [CR][LF]

   alle anderen Eingaben durch [CR] abgeschlossen werden die auf dem
   DIP-Schalter akivierten Kanäle übergeben. (auf GND gelegt)

   Dabei gilt die Zuordnung
   Kanal 1 -> A0 -> D12
   Kanal 2 -> A1 -> D11
   Kanal 3 -> A2 -> D10
   Kanal 4 -> A3 -> D9
   Kanal 5 -> A4 -> D8
   Kanal 6 -> A5 -> D7
   Kanal 7 -> A6 -> D6
   Kanal 8 -> A7 -> D5

   Ausgabeformat über Seriell:
   START [CR][LF]         (Programmstart -> Clear Page)
   HEAD  [CR][LF]         (Überschriften aus Excel)
   KANAL,4,123 [CR][LF]   (zB: Kanal 4 mit Wert 123)

   Verkablelung mit Ethernet-Kabel
   Belegung Logger   Auswerter
    Pin1 GND          GND
    Pin2 +VCC         +Vcc
    Pin3 GND          GND
    Pin4 TxD          RxD 25
    Pin5 GND          GND
    Pin6 RxD          TxD 26
    Pin7 GND          GND
    Pin8 +VCC         +Vcc

*/
// für Infrarot Diode
#undef IROT

// Libraries to get time from NTP Server
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPmDNS.h>
#include <ESPAsyncWebServer.h>

#include <NTPClient.h>
#include <WiFiUdp.h>

#include <Adafruit_NeoPixel.h> // RGB LEDs
#include <SPI.h>             // SPI für die Kommunikation
#include <SD.h>
#include <TFT_eSPI.h> // Graphics and font library for ST7735 driver chip
#include <FS.h>
// RTC clock
#include <DS1302.h>
#include <Wire.h>
#ifdef IROT
// IR Diode
#include <IRremote.h>
#endif
/* Kombidisplay TFT + SD-Leser
    ------ TFT
    VCC     (1) -> VCC
    GND     (2) -> GND
    CS      (3) -> G17 (21) eventuelle Korrektur in \Arduino\libraries\TFT_eSPI\User_Setup.h (Zeile 162)
    RES     (4) -> G14
    A0/RS   (5) -> G2
    SDA     (6) -> G23
    SCK     (7) -> G18
    LEDA    (8) -> 3.3V
    ------ SD
    SD_CS   (1) -> G05
    SD_MOSI (2) -> G23
    SD_MISO (3) -> G19
    SD_SCK  (4) -> G18
*/

//TFT
TFT_eSPI tft = TFT_eSPI();  // Invoke library, pins defined in User_Setup.

// SD Karte
String DatenFile = "/Messwerte.csv";
File myFile;
String textin = "Wir haben nix";
bool FileStat = false;
unsigned int Intervall = 10000; // Auslese Intervall
unsigned long zeit;

// für Grafik
int xpos = 0;
int ypos = 0;
int ylast = 128;
int ymin = 31;
int ymax = 128;
int yhoch = ymax - ymin;

// Linienbuffer y-Werte für die Kanäle
int linie[162] [9];
int lcnt, gcnt;

// Korrektur der Farbfehler im Include File ST7735.h im 565 (16 Bit) System
#define C_BLUE TFT_BLUE
#define C_RED TFT_RED
#define C_GREEN TFT_GREEN
#define C_YELLOW TFT_YELLOW
#define C_ORANGE TFT_GOLD
#define C_MAGENTA TFT_MAGENTA
#define C_CYAN TFT_CYAN
#define C_WHITE TFT_WHITE
#define C_BLACK TFT_BLACK
#define C_BACK TFT_DARKGREY

// Farben, nur so zum Spass
unsigned int farbe[] = {C_RED, C_GREEN, C_BLUE, C_CYAN, C_ORANGE, C_MAGENTA, C_YELLOW, C_WHITE, TFT_SKYBLUE };
int anzFarbe = 9;
int aktFarbe = 0;
int Zeile = 200; // Zeile auf TFT

// Funktionsauswahl
#define loeschen 33 // Start Routine

// Seriell Schnittstelle UART2
#define RXD2 16
#define TXD2 17 // ACHTUNG wird von CS des Displays benutzt
//Korrektur möglich in \Arduino\libraries\TFT_eSPI\User_Setup.h (Zeile 16
// Seriell Schnittstelle UART1
//(modifiziernt in HardwareSerial.cpp
//Datei: Arduino\ESP32\arduino-esp32-master\arduino-esp32-master\cores\esp32\HardwareSerial.cpp
#define RXD1 25 //SD2
#define TXD1 26 //SD1

#ifdef IROT
// IR Decoder
int IR_PIN = 27;
IRrecv irrecv(IR_PIN);
decode_results results;
unsigned int IR_ein = 0;
unsigned long  IR_wert;
char hexbuff[28];
int IR_code;
#endif

// WLAN Setup
char ssid[64];  // SSID im Configfile SSID:xxxx
char password[64]; // Password im Configfile: PWD:xxxx
char mDNSname[64]; // Servername im Web
String configFile = "/Logger.cfg"; // Configfile auf SD Karte
bool WiFiOk = false;
const char* PARAM_INPUT_1 = "state";
// Create AsyncWebServer object on port 80
AsyncWebServer server(80);

// Webseitenstruktur
const char index_html[] PROGMEM = R"rawliteral(
<!DOCTYPE HTML><html>
<head>
  <title>ESP Web Server hiz</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    html {font-family: Arial; display: inline-block; text-align:left;}
    h2 {font-size: 24px;}
    h4 {font-size: 20px;}
    p {font-size: 16px;}
    body {max-width: 600px; margin:0px auto; padding-bottom: 5px;}}
    progress {height:25px; width: 150px;}
    table {text-align: right; cellspacing:15px; cellpadding:15px;  }
  </style>
</head>
<body>
  <h2>Datenlogger Web Server</h2>
  %BUTTONPLACEHOLDER%
<script>
setInterval(function ( ) {
  var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function() {
   if (this.readyState == 4 && this.status == 200) {
      document.getElementById("ergebnis").innerHTML = this.responseText;
    }
  };
  xhttp.open("GET", "/state", true);
  xhttp.send();
}, %INTERVALL% ) ;
</script>
</body>
</html>
)rawliteral";

// Save reading number on RTC memory
RTC_DATA_ATTR int readingID = 0;
String dataMessage;
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP);
// Variables to save date and time
String dayStamp;
String timeStamp;
String lasttime = "";
String lastday = "";


// RTC Modul
const int RT_RSTpin   = 21;  // Chip Enable  RST
const int RT_DATpin   = 13;  // Input/Output DAT
const int RT_CLKpin = 15;  // Serial Clock CLK
// Create a DS1302 object.
DS1302 rtc(RT_RSTpin, RT_DATpin, RT_CLKpin);

// MesswerteSpeicher
int Kanal[9];
int lastkan[9];
int MessString;

// Seriall LED
// LEDs
// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PIN 32
#define NUM_PIXELS  8
#define aLOW 0
//#define aHIGH 255
#define aHIGH 128
int LEDpassiv[9]; // Farben für jede LED Wartezeit
int LEDaktiv[9]; // Farben für jede LED Mesung
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PIN, NEO_RGB + NEO_KHZ400);


//*****************************************************************
//SetUp
//*****************************************************************
void setup() {
  int cnt;
  //Serial2.begin(9600, SERIAL_8N1, RXD2, TXD2);
  Serial1.begin(9600, SERIAL_8N1, RXD1, TXD1);
  Serial.begin(115200);
  Serial.println(F("Datenauswertung für Datenlogger auf ESP32 mit WebServer"));
  // für Funktionsauswahl
  strip.begin();
  ColorLED(128, 128, 128);
  pinMode (loeschen, INPUT); // Start routine
  digitalWrite (loeschen, HIGH); // Start routine
  //Init  Screen
  tft.init();
  tft.fillScreen(C_BLACK);
  tft.setRotation(3);
  // setTextSize(groesse);
  tft.setTextSize(2);
  // setCursor(links,oben);
  tft.setCursor(5, 0);
  // setTextColor(farbe);
  tft.setTextColor(C_WHITE);
  // print(text);
  tft.print("DataLogger");
  tft.setTextSize(1);
  tft.setCursor(0, 20);
  //tft.println((String)"File:" + DatenFile);
  tft.drawLine(0, 30, 127, 30, C_BLUE);
  tft.setCursor(0, 45);

  // SD Karte
  Serial.print(F("Initializing SD card..."));
  digitalWrite( 5, HIGH); // SD card chips select, must use GPIO 5 (ESP32 SS)
  delay(50);

  if (!SD.begin()) {
    Serial.println(F("initialization failed!"));
    tft.setTextColor(C_RED);
    tft.println("SD-Fehler");
    //while (1);
  }
  Serial.println(F("initialization done."));
  //listDir(SD, "/", 1);

    tft.setTextColor(C_GREEN);
    tft.println("SD fertig");
    delay(10);

#ifdef IROT
  //  Infrarot
  irrecv.enableIRIn();
  tft.println("IR fertig");
#endif

  tft.println("alles fertig");
  Serial.println(F("Inizialisierung fertig"));
  aktFarbe++;

  // Einlesen config File ssid, password, luftbasis
  readConfig();

  //Serial.println ("SSID: " + (String)ssid + "pwd: " +  (String)password);
  ColorLED(128, 0, 128);

  // Connect to Wi-Fi network with SSID and password
  Serial.println("Connecting to: " + (String)ssid);
  tft.print("WLAN..");

  //**************************************************************************************
  // Connect WLAN
  int wlancnt = 0,
  WiFiOk = false;
  while ((WiFi.status() != WL_CONNECTED) &&  (wlancnt < 5)) {
    wlancnt++;
    tft.print(wlancnt);
      WiFi.mode(WIFI_OFF);
      WiFi.mode(WIFI_STA);
      WiFi.begin(ssid, password);
    Serial.println("WiFi begin" + (String)wlancnt);
    delay(500);
    zeit = millis();
    while ((WiFi.status() != WL_CONNECTED) && ((millis() - zeit) < 5000)) {
      //WiFi.disconnect();
      delay (1000);
      //WiFi.reconnect();
      Serial.print(".");
    }
  }
  Serial.println(WiFi.localIP());
  //tft.print ("\nIP:");
  //tft.println(WiFi.localIP());
  //if (WiFi.status() != WL_CONNECTED) {
  //  ESP.restart();
  //}
  if (WiFi.status() == WL_CONNECTED) {
    WiFiOk = true;
    Serial.println(F("\nWiFi connected."));
    tft.setTextColor(C_CYAN);
    tft.println("\nWifi: " + (String)ssid);
  
  //***************************************************************************
  // Initialize a NTPClient to get time

    timeClient.begin();
    // Set offset time in seconds to adjust for your timezone, for example:
    // GMT +1 = 3600
    // GMT +8 = 28800
    // GMT -1 = -3600
    // GMT 0 = 0
    timeClient.setTimeOffset(3600);
    getTimeStamp();
    Serial.println("Startzeit: " + dayStamp + " " + timeStamp);
    tft.println(dayStamp + " " + timeStamp);

    // Setzen realTime Clock von NTP Server wenn Wifi da
    setRTCtime();
    
// Open File Messwerte
  getDatenfile();
  if (!SD.exists (DatenFile)) {
    FileStat = false;
    tft.println(DatenFile + " fehlt: ");
    Serial.println(DatenFile);
    // Open File und neu anlegen
   FileNeu();
   tft.println((String)"Neu:" + DatenFile);
  }
  
  
//***************************************************************************
// WebServer 
      // Print ESP Local IP Address
  Serial.println(WiFi.localIP());
// mDNS Name vergeben
if (!MDNS.begin(mDNSname)) {
  Serial.println ("mDNS Startet nicht - kein Name:"+ (String)mDNSname);
} else {
  Serial.print("Servername: " + String(mDNSname));
}
//mDNS Dienste hinzufügen
  MDNS.addService("http", "tcp", 80);
  MDNS.addServiceTxt("http", "tcp", "url", "http://"+(String)mDNSname);
  MDNS.addServiceTxt("http", "tcp", "webthing", "true");
  
  // Route for root / web page
  server.on("/", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send_P(200, "text/html", index_html, processor);
  });

  // Send a GET request to <ESP_IP>/state
  server.on("/state", HTTP_GET, [] (AsyncWebServerRequest *request) {
    request->send(200, "text/plain",Inhalt());
  });
  // Start server
  server.begin();
//************************************************************************************************
   
  } else {
    tft.setTextColor(C_RED);
    tft.println("\nKein WiFi");
    WiFi.disconnect();
  }

  delay(2000);

  zeit = millis();
  //Löschen TFT und zurücksetzen Messwerte
  tft_reset();
  ColorLED(0, aHIGH, 0);
  // für Uhrzeit
  tft.fillRect(0, 20, 160, 10, C_BLUE);
}

//*****************************************************************
//Programmschleife
//*****************************************************************
void loop() {
  int EinWert;
  String EinLeser;
  int cnt;
  
  // Taste gedrückt= Löschen File
  if (digitalRead(loeschen) == LOW) {
    ColorLED(aHIGH, aLOW, aLOW);
    while (digitalRead(loeschen) == LOW) ; // bis tage losgelaassen
    Serial.println(F("Datenfile neu anlegen?"));
    // Wenn Taste innerhalt 3 sekunden gedrückt
    Zeile = 200;
    tft_raus(DatenFile + "neu?");
    tft_raus("Taste druecken!");
    zeit = millis();
    while ((millis() - zeit) < 3000) {
      if (digitalRead(loeschen) == LOW) {
        ColorLED(aHIGH / 2, aHIGH / 2, aLOW);
        tft_raus("neu anlegen");
        if (SD.exists(DatenFile)) {
          SD.remove(DatenFile);
        }
        // neu Anlegen
        FileNeu();
                
        break;}
      }
    
    delay(2000);
    tft_reset();

  }
  // Zeit  Einblenden

  display_zeit();

  // Einlesen Messwerte
  if ((millis() - zeit) > Intervall) {
    zeit = millis();
    getDatenfile();
    
    //ColorLED(aLOW, aHIGH / 2, aHIGH / 2);
    arrayLED(LEDaktiv);

    /// Bessere Lösung
    for (cnt = 0; cnt <= 8; cnt++)  {
      Kanal[cnt] = -1;
    }

    Serial1.println("");
    // einlesen serial
    EinLeser = "";
    while (Serial1.available() > 0) {
      EinWert = Serial1.read();
      // nur größer Space
      if (EinWert > 32) {
        EinLeser = String(EinLeser + char(EinWert));
      }
      //CR
      if (EinWert == 13) {
        //tft_raus(EinLeser);
        zerlegen(EinLeser);
        EinLeser = "";
      }

    }
    
    // Existiert Datenfile?
    if (!SD.exists (DatenFile)) {
    FileStat = false;
    tft_raus(DatenFile + " fehlt: ");
    Serial.println(DatenFile + " fehlt, neu anlegen");
    // Open File und neu anlegen
    FileNeu();
    }
    // In Datei schreiben
    myFile = SD.open(DatenFile, FILE_APPEND);
    if (!myFile) {
      tft_raus("FileFehler");
      Serial.println(DatenFile + " File Fehler");

    } else {
      myFile.print(dayStamp + ";" + timeStamp + ";");
      for (cnt = 1; cnt <= 8; cnt++) {
        if (Kanal[cnt] >= 0) {
          myFile.print(Kanal[cnt] );
        }
        if (cnt < 8) {
          myFile.print(";");
        }
      }
      myFile.println("");
    }
    myFile.close();
    TFT_Tabelle();
    TFT_Grafik();
  }
  arrayLED(LEDpassiv);


}

//*****************************************************************
//Subroutinen
//*****************************************************************

void zerlegen (String EinString) {
  int kan;
  int wert;
  int pos1, pos2;
  // nur wenn es mit "KANAL" beginnt
  if (EinString.indexOf("KANAL") >= 0) {
    pos1 = EinString.indexOf(",") + 1 ;
    pos2 = EinString.indexOf(",", pos1);
    kan = EinString.substring(pos1, pos2 ).toInt();
    wert = EinString.substring(pos2 + 1).toInt();
    Kanal[kan] = wert;
    //tft_raus((String)kan + "-" + (String)wert);
  }
}

//*****************************************************************
//TFT
void TFT_Tabelle() {
  int kan;
  int tline;
  int pos;
  for (kan = 1; kan <= 8; kan++) {
    if (lastkan[kan] != Kanal[kan]) {
      if (kan >= 5) {
        tline = 10;
        pos = 5;
      } else {
        tline = 0;
        pos = 1;
      }
      if (lastkan[kan] != -1) {
        tft.setCursor((kan - pos) * 40, tline);
        tft.setTextColor(C_BACK);
        tft.print((String)kan + ":" + (String)lastkan[kan]);
      }

      if (Kanal[kan] != -1) {
        tft.setCursor((kan - pos) * 40, tline);
        tft.setTextColor(farbe[kan - 1]);
        tft.print((String)kan + ":" + (String)Kanal[kan]);
        lastkan[kan] = Kanal[kan];
        LEDaktiv[kan - 1] = strip.Color(aLOW, aHIGH / 2, aHIGH / 2);
        LEDpassiv[kan - 1] = strip.Color(aLOW, aHIGH, aLOW);

      } else {
        tft.fillRect((kan - pos) * 40, tline , 40, 10, C_BACK);
        Serial.println(F("und weg der Kanal"));
        lastkan[kan] = -1;
        LEDaktiv[kan - 1] = strip.Color(aLOW, aLOW, aLOW);
        LEDpassiv[kan - 1] = strip.Color(aLOW, aLOW, aLOW);
      }
    }
  }
}

// Ausgeben der Grafik auf TFT für max 8 Kanäle
void TFT_Grafik() {
  //Serial.println("Grafik");
  // Löschen letze Grafikpunkte
  tft.drawLine(0, ymin, 0, ymax, C_BLACK);
  xpos = 160;
  // Wert in grafikarray berechnen
  for (gcnt = 1; gcnt <= 8; gcnt++) {
    if (Kanal[gcnt] != -1) {
      linie[xpos][gcnt] = ymax - ( yhoch * Kanal[gcnt] / 1023);
      // Serial.println((String) "Kanal" + gcnt +":" + linie[xpos][gcnt]);
    } else {
      linie[xpos][gcnt] = -1;
    }
  }
  for (lcnt = 1; lcnt <= xpos; lcnt++) {
    tft.drawLine(lcnt, ymin, lcnt, ymax, C_BLACK); // löschen alten punkt
    for (gcnt = 1; gcnt <= 8; gcnt++)  {
      if ((linie[lcnt][gcnt] >= 0) && (linie[lcnt - 1][gcnt] >= 0)) {
        tft.drawLine(lcnt - 1, linie[lcnt - 1][gcnt], lcnt, linie[lcnt][gcnt], farbe[gcnt - 1]);
        //Serial.println("lcnt:"+(String)lcnt+" gcnt:" +(String)(gcnt));
      }
      // Array linie umschichten
      linie[lcnt - 1][gcnt] = linie[lcnt][gcnt];
    }
  }
}

// Zeit oben Einblenden
void display_zeit() {
  getRTCtime(); // RTC Time
  // getTimeStamp(); // WLan Time
  if (lasttime != timeStamp) {
    //tft.fillRect(0, 150, 127, 10, C_BLUE);
    tft.setCursor(1, 21);
    tft.setTextColor(C_BLUE);
    tft.print(lastday + " " + lasttime);
    tft.setCursor(1, 21);
    tft.setTextColor(C_YELLOW);
    tft.print(dayStamp + " " + timeStamp);
    lasttime = timeStamp;
    lastday = dayStamp;
    DatenFile=dayStamp+".csv";
  }
}

// Ausgabe Zeile auf TFT
void tft_raus (String tfttext) {
  Zeile += 10;
  // Löschen Display
  if (Zeile > 140) {
    tft.fillRect(0, 40, 127, 110, C_BLACK);
    Zeile = 40;
  }
  aktFarbe = (aktFarbe < anzFarbe) ? aktFarbe + 1 : 0;
  tft.setTextColor(farbe[aktFarbe]);
  tft.setCursor(0, Zeile);
  tft.println(tfttext);
}

// Löschen Messwerte und Grafik auf TFT und Kanäle auf 0 Setzen
void tft_reset() {
  int cnt;
  //Löschen TFT und zurücksetzen Messwerte
  tft.fillRect(0, 0, 160, 20, C_BACK);
  tft.fillRect(1, 20, 160, 128 - 40, C_BLACK);
  tft.fillRect(0, 20, 160, 10, C_BLUE); // für Uhr
  // Linen Buffer der Grafik löschen
  for (cnt = 0; cnt <= 8; cnt++) {
    lastkan[cnt] = -4;
    Kanal[cnt] = -1;
    LEDaktiv[cnt] = strip.Color(aLOW, aLOW, aLOW); // Alle LEDs aus
    LEDpassiv[cnt] = strip.Color(aLOW, aLOW, aLOW); // Alle LEDs aus
    for (gcnt = 0; gcnt <= 160; gcnt++) {
      linie[gcnt][cnt] = -1;
    }
  }
}

#ifdef IROT
//*****************************************************************
//Infrarot Fernbedienung

// IR-Belegung Neu
#define IR_0        0xFF4AB5
#define IR_1        0xFF6897
#define IR_2        0xFF9867
#define IR_3        0xFFB04F
#define IR_4        0xFF30CF
#define IR_5        0xFF18E7
#define IR_6        0xFF7A85
#define IR_7        0xFF10EF
#define IR_8        0xFF38C7
#define IR_9        0xFF5AA5
#define IR_BarCode  0xFFA857
#define IR_SollSet  0xFFE01F
#define IR_Ein      0xFF52AD
#define IR_Aus      0xFF42BD
#define IR_SollEin  0xFF22DD
#define IR_Tara     0xFF906F
#define IR_CodeIn   0xFF02FD
#define IR_CR       0xFFC23D
// --------------------------------------------------------------------

// Codeumsetzung der IR Fernbedienung

unsigned long IR_Code[] = {IR_0, IR_1, IR_2, IR_3, IR_4 , IR_5, IR_6, IR_7, IR_8, IR_9,
                           IR_CR, IR_CodeIn, IR_BarCode, IR_SollSet, IR_Tara, IR_Aus, IR_Ein, IR_SollEin
                          };
int IR_Wert[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 120, 121, 122, 123, 124, 125, 126, 127};

int Get_IR(unsigned long inwert) {
  //unsigned long inwert;
  int cnt;
  int IR_anz = sizeof(IR_Code);
  int rwert;
  rwert = -1;
  Serial.print(inwert);
  if (inwert != 0xffffffff) {
    for (cnt = 0; cnt < IR_anz; cnt++) {
      if (inwert == IR_Code[cnt]) {
        rwert = IR_Wert[cnt];

      }
    }
  }
  return (rwert);
}

unsigned long Get_IRcode() {
  unsigned long inwert;
  int cnt;
  unsigned long rwert = 0xffffffff;
  // Eingabe von Zeichen?
  if (irrecv.decode(&results)) {
    irrecv.resume();
    delay(100);
    inwert = results.value;
    rwert = inwert;
  }
  return (rwert);

}
#endif


//*****************************************************************
//Timer RTC + NTP

void getRTCtime() {
  Time  t = rtc.time();
  // Format the time and date and insert into the temporary buffer.
  char buf1[16];
  char buf2[16];
  //Datum
  snprintf(buf1, sizeof(buf1), "%04d-%02d-%02d",
           t.yr, t.mon, t.date);
  //Zeit
  snprintf(buf2, sizeof(buf2), "%02d:%02d:%02d",
           t.hr, t.min, t.sec);

  dayStamp = buf1;
  timeStamp = buf2;
  //Serial.println(dayStamp+" "+timeStamp);

}

void setRTCtime() {

  // Zeit von NTP Client
  getTimeStamp();
  getFormattedDate();


  rtc.writeProtect(false);
  rtc.halt(false);

  // Make a new time object to set the date and time.
  // Format (int Jahr, int Monat, int Tag, int Stunde, int Minute, int Sekunde , Time::Wochentag)
  Time t(dayStamp.substring(0, 4).toInt(), dayStamp.substring(5, 7).toInt(), dayStamp.substring(8, 10).toInt(),
         timeStamp.substring(0, 2).toInt(), timeStamp.substring(3, 5).toInt(), timeStamp.substring(6, 8).toInt(),
         Time::kSunday);

  // Set the time and date on the chip.
  rtc.time(t);

}

String dayAsString(const Time::Day day) {
  switch (day) {
    case Time::kSunday: return "Sunday";
    case Time::kMonday: return "Monday";
    case Time::kTuesday: return "Tuesday";
    case Time::kWednesday: return "Wednesday";
    case Time::kThursday: return "Thursday";
    case Time::kFriday: return "Friday";
    case Time::kSaturday: return "Saturday";
  }
  return "(unknown day)";
}


// Function to get date and time from NTPClient
void getTimeStamp() {
  while (!timeClient.update()) {
    timeClient.forceUpdate();
  }
  // Get Time & Date
  timeStamp = timeClient.getFormattedTime();
  dayStamp = getFormattedDate();
  //Serial.println("Zeit: " + dayStamp +" / " + timeStamp);
  // Tag ermitteln
  Serial.println(timeClient.getDay());
}

// Datum im richtigen Format
#define LEAP_YEAR(Y)     ( (Y>0) && !(Y%4) && ( (Y%100) || !(Y%400) ) )

String getFormattedDate() {
  unsigned long rawTime = timeClient.getEpochTime() / 86400L;  // in days
  unsigned long days = 0, year = 1970;
  uint8_t month;
  static const uint8_t monthDays[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

  while ((days += (LEAP_YEAR(year) ? 366 : 365)) <= rawTime)
    year++;
  rawTime -= days - (LEAP_YEAR(year) ? 366 : 365); // now it is days in this year, starting at 0
  days = 0;
  for (month = 0; month < 12; month++) {
    uint8_t monthLength;
    if (month == 1) { // february
      monthLength = LEAP_YEAR(year) ? 29 : 28;
    } else {
      monthLength = monthDays[month];
    }
    if (rawTime < monthLength) break;
    rawTime -= monthLength;
  }
  String monthStr = ++month < 10 ? "0" + String(month) : String(month); // jan is month 1
  String dayStr = ++rawTime < 10 ? "0" + String(rawTime) : String(rawTime); // day of month
  return String(year) + "-" + monthStr + "-" + dayStr ;
}

//*****************************************************************
//SD-Karte

// Einlesen Config File ssid, password, luftbasis
void readConfig() {
  String textin;
  String keyword;
  String inhalt;
  int pos;
  int inhlang;

  if (SD.exists(configFile)) {
    myFile = SD.open(configFile, FILE_READ);

    while (myFile.available()) {
      textin = myFile.readStringUntil('\n');
      // Leerzeichen löschen
      textin.replace(" ", "");
      // keyword finden
      pos = textin.indexOf(':');
      if (pos > 0) {
        keyword = textin.substring(0, pos);
        keyword.toUpperCase();
        inhalt = textin.substring(pos + 1);
        //Serial.println("key:" + keyword + "  Inhalt:" + inhalt);
        if (keyword == "SSID") {
          inhlang = inhalt.length();
          inhalt.toCharArray(ssid, inhlang);
          tft.println("ssid:" + (String)ssid);
        }
        if (keyword == "PWD") {
          inhlang = inhalt.length();
          inhalt.toCharArray(password, inhlang);
          //tft.println("pwd:" + (String)password);
          tft.println("pwd: ******" );
        }
        if (keyword == "SERVER") {
          inhlang = inhalt.length();
          inhalt.toCharArray(mDNSname, inhlang);
          tft.println("Server:" + (String)mDNSname);
        }
        // Auslese intervall
        if (keyword == "INTERVALL") {
          Intervall =    inhalt.toInt();
          tft.println("Int:" + (String)Intervall);
        }
        //toDo hier kommen die Kanalauswertungen

      }

    }
  } else {
    Serial.println("Config File nicht gefunden: " + configFile);
  }
}

void getDatenfile() {
      // Filename aud Datum ermitteln
     DatenFile="/"+ dayStamp+".csv";
    //DatenFile.replace("-","");
    DatenFile.replace(" ","");
}


// Datenfile neu anlegen
void FileNeu() {
      // Open File und neu anlegen
    getDatenfile();
    myFile = SD.open(DatenFile, FILE_WRITE);
    if (!myFile) {
      Serial.println(F("Kann nicht geöffnet werden"));
      tft_raus("geht nicht");
      FileStat=false;
      myFile.close();
    } else {
      myFile.println("Datum;Zeit;Kanal 1;Kanal 2;Kanal 3;Kanal 4;Kanal 5;Kanal 6;Kanal 7;Kanal 8");
      myFile.close();
      Serial.println ("File angelegt: " + DatenFile);
      tft_raus("neu anglegt");
      FileStat=true;
     }
}

/*
  //Directory Der SD-Karte
  void listDir(fs::FS & fs, const char * dirname, uint8_t levels) {
  Serial.printf("Listing directory: %s\n", dirname);

  File root = fs.open(dirname);
  if (!root) {
    Serial.println("Failed to open directory");
    return;
  }
  if (!root.isDirectory()) {
    Serial.println("Not a directory");
    return;
  }
  File file = root.openNextFile();
  while (file) {
    if (file.isDirectory()) {
      Serial.print("  DIR : ");
      Serial.println(file.name());
      if (levels) {
        listDir(fs, file.name(), levels - 1);
      }
    } else {
      Serial.print("  FILE: ");
      Serial.print(file.name());
      Serial.print("  SIZE: ");
      Serial.println(file.size());
    } file = root.openNextFile();
  }
  }
*/
//********************************************************************************
//    Schalten der Color LEDs alle Farben gleich übergben werden rot, grün blau
void ColorLED(int arot, int agruen, int ablau) {
  /*  analogWrite (LEDrot, aHIGH - arot);
    analogWrite (LEDgruen, aHIGH - agruen);
    analogWrite(LEDblau, aHIGH - ablau);
  */

  int cnt;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(arot, agruen, ablau));
  }
  strip.show();
}

// Schalten ColorLEDs für jeden Kanal Farben in LEDcol
void arrayLED(int farben[]) {
  int cnt;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, farben[cnt]);
  }
  strip.show();
}


//********************************************************************************
//    WLAN Routinen

// Replaces placeholder with button section in your web page
String processor(const String& var){
  if(var == "BUTTONPLACEHOLDER"){
    String buttons= "<h4>Messwerte</h4><span id=\"ergebnis\">" + Inhalt() +" </span>";
    //Serial.println(buttons);
    return buttons;
  }
    if (var=="INTERVALL") {
      return (String(Intervall));
  }
  
  return String();
}

//String webcol[9]={"#000000","#ff4040","#20ff20","#8080ff","#ffff00","#00ffff","#ff8000","#ff00ff","#f0f0f0"};
String webcol[9]={"#000000","#ff4040","#20ff20","#8080ff","#00ffff","#ff8000","#ff00ff","#ffff00","#f0f0f0"};
// Webseiten inhalt 
// Werte in Tabele und Grafik

String Inhalt() {
String Rueckgabe;
char buff1[128];
char buff2[8];
String kString;
int ccnt;

    //Rueckgabe="<div style=\"line-height:150%;\">";
    Rueckgabe="<table cellspacing=5 cellpadding=4><tr><th>Kanal</th><th>Wert</th><th>Graph</th></tr>";
    for (ccnt = 1; ccnt<=8; ccnt++) {
    kString="-----";
    if (Kanal[ccnt]>=0) {
     snprintf(buff2,8,"%4d",Kanal[ccnt]);
     kString=String(buff2);
    }
    snprintf(buff1,128,"<tr Style=\"background-color:%s;\"><td>%d</td><td>%s</td><td><progress max=\"1024\" value=\"%d\"></progress></td></tr>",webcol[ccnt],ccnt,kString,Kanal[ccnt]);
    Rueckgabe = Rueckgabe +String(buff1);
    }
    Rueckgabe=Rueckgabe+"</table>";
//Serial.println (Rueckgabe);
    return (Rueckgabe);
}
