/* *********************************************************************
    ESP32 - TFTAnaloguhr
    hiz 09/2023
 ********************************************************************* */

String VERS = "Vers 2.1 hiz 9/2023";

#include <SPI.h>  // SPI für die Kommunikation
// Libraries to get time from NTP Server
#include <WiFi.h>
#include <NTPClient.h>
#include <WiFiUdp.h>

/* RTC clock
RSTpin     16  Chip Enable  RST
RT_DATpin  13  Input/Output DAT
RT_CLKpin  15   Serial Clock CLK
*/
#include <DS1302.h>

/*  LCD 2 Zeilen Display
    GND   -> GND
    VCC   -> +5V
    SCL   -> G22
    SDA   -> G21
*/
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);  // Set the LCD address to 0x27 for a 16 chars and 2 line display

// TFT Rund GC9A01A
/*                Nano  ESP32
VCC 5V
GND GND
SCL Clock         13    GP18
SDA Data In       11    GP23
DC Data/Command    7    GP17 (alt 16)
CS Chip Select    10    GP12 (alt 22)
RST Reset          8    GP 4
*/
#include "Adafruit_GFX.h"
#include "Adafruit_GC9A01A.h"
#include <Adafruit_ImageReader.h>
#define TFT_DC 17
#define TFT_CS 12
    Adafruit_GC9A01A tft(TFT_CS, TFT_DC);
#define PI 3.1415926535897932384626433832795
// SD Kartenleser
/*
    GND
    MISO (3) -> G19
    SCK  (4) -> G18
    MOSI (2) -> G23
    CS   (1) -> G05
    5V
    3.3V
    GND
 */
//#include <SD.h>
//#include <FS.h>
#include <SdFat.h>
#define SD_CS 5
File myFile;
char *DatenFile[] = { "/Ziffer1.bmp", "/Ziffer2.bmp", "/Ziffer3.bmp", "/Ziffer4.bmp" };  // Standard Ziffernblätterblatt
int Ziffercnt = 0;
bool FileStat = false;
SdFat SD;                         // SD card filesystem
Adafruit_ImageReader reader(SD);  // Image-reader object, pass in SD filesys
Adafruit_Image img;
// Umschalter Ziffernblatt
#define ZIFFERPIN 32  //n Zifferblattwechsel
bool interrupt = false;
#define ROTATEPIN 33  // Zifferlatt drehen

// RTC Modul
const int RT_RSTpin = 16;  // Chip Enable  RST
const int RT_DATpin = 13;  // Input/Output DAT
const int RT_CLKpin = 15;  // Serial Clock CLK
// Create a DS1302 object.
DS1302 rtc(RT_RSTpin, RT_DATpin, RT_CLKpin);

unsigned long zeit = 0;

// WLAN Setup
char ssid[64] = "TSS-Fritz\0";
char password[64] = "bagger-112\0";
bool WiFiStat = false;
// LED Definition Pins für rot/grün
#define WiFiTrue 27
#define WiFiFalse 26
// Save reading number on RTC memory
RTC_DATA_ATTR int readingID = 0;
String dataMessage;
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP);

// Variables to save date and time
String formattedDate;
String dayStamp;
String timeStamp;
String lastTime;
String lastDay;
int aktHr, lastHr;
int aktMin, lastMin;
int aktSec, lastSec;


//*****************************************************************************
// Interruptroutine um Ziffernbaltt zu wechseln
// Startet wenn Pin 2 auf LOW geht
// setzt Variable interrupt auf true und wird in dr Loop bearbeitet
void IRAM_ATTR ChangeZiffer() {
  interrupt = true;
}

// **************************************************************************
void setup() {
  int cnt;
  Serial.begin(115200);
  while (!Serial)
    ;
  Serial.println(F("ESP32 - TFT-Analoguhr"));
  Serial.println(VERS);
  // WiFiLED
  pinMode(WiFiTrue, OUTPUT);
  pinMode(WiFiFalse, OUTPUT);
  digitalWrite(WiFiTrue, LOW);
  digitalWrite(WiFiFalse, HIGH);

  // Interrupt für Ziffernblattwechsel
  pinMode(ZIFFERPIN, INPUT_PULLUP);
  attachInterrupt(ZIFFERPIN, ChangeZiffer, RISING);

  // Ausrichtung Display
  pinMode(ROTATEPIN, INPUT_PULLUP);  // wenn 0, rotienen um 180 Grad (2)

  // Init LCD
  lcd.begin();
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("HIZ-TFT Uhr");
  lcd.setCursor(0, 1);
  lcd.print(VERS.substring(0, 8));

  // Init TFT
  tft.begin();
  //tft.setRotation(0); //(2);
  cnt = (digitalRead(ROTATEPIN) == true) ? 0 : 2;
  tft.setRotation(cnt);
  tft.fillScreen(GC9A01A_RED);
  delay(1000);
  tft.fillScreen(GC9A01A_GREEN);
  delay(1000);
  tft.fillScreen(GC9A01A_BLUE);
  delay(1000);
  tft.fillScreen(GC9A01A_BLACK);
  tft.setCursor(10, 100);
  tft.setTextColor(GC9A01A_WHITE);
  tft.setTextSize(2);
  tft.println("HIZ-TFT Analoguhr");
  tft.setTextSize(1);
  tft.setCursor(10, 120);
  tft.print(VERS);

  Serial.println(F("Soweit die Anzeigen."));

  // SD Karte
  FileStat = true;
  Serial.print(F("Initializing SD card..."));
  digitalWrite(SD_CS, HIGH);  // SD card chips select, must use GPIO 5 (ESP32 SS)
  delay(2000);

  // SD Mehrmals Starten zur Sicherheit

  cnt = 0;
  while ((!SD.begin(SD_CS, SD_SCK_MHZ(25))) && (cnt < 20)) {
    cnt++;
    delay(100);
    Serial.print(F("."));
  }

  if (!SD.begin(SD_CS, SD_SCK_MHZ(25))) {
    FileStat = false;
    Serial.println(F("#"));
    Serial.println(F("Fehler Initialiserung der SD Karte!"));
    tft.fillScreen(GC9A01A_RED);
    tft.setTextColor(GC9A01A_YELLOW);
    tft.setTextSize(3);
    tft.setCursor(10, 100);
    tft.println("SD-Fehler");
  } else {
    Serial.println(F("SD-Card erfolgreich."));
    FileStat = true;
  }

  // Connect to Wi-Fi network with SSID and password
  Serial.println("Connecting to: " + (String)ssid);
  WiFiStat = WiFiConnect();
  if (WiFiStat == true) {
    // Initialize a NTPClient to get time
    timeClient.begin();
    // Set offset time in seconds to adjust for your timezone, for example:
    // GMT +1 = 3600
    // GMT +8 = 28800
    // GMT -1 = -3600
    // GMT 0 = 0
    timeClient.setTimeOffset(7200);
    getTimeStamp();
    Serial.println("Startzeit: " + dayStamp + " " + timeStamp);
    lastTime = timeStamp;
    lastDay = "";
    // Setzen realTime Clock von NTP Server wenn Wifi da
    setRTCtime();

    delay(500);
  }
  // Start
  Serial.println(F("Inizialisierung fertig"));
  delay(1000);
  zeit = 0;
  lastHr = 0;
  lastMin = 0;
  Zifferblatt(DatenFile[0]);
}


// **************************************************************************
void loop() {
  int LEDcnt;
  int cnt;
  int i;
  int wert;
  unsigned int HellIn;

  // Datum, Zeit,
  getRTCtime();
  // neue Zeit, also Sekunde
  //Serial.println(timeStamp);
  lastTime = "  ";
  if (timeStamp != lastTime) {
    // Neue Stunde, also RTC setzen
    if (aktHr != lastHr) {
      lastHr = aktHr;
      setRTCtime();
    }
    // LCD Display
    lcd.setCursor(0, 0);
    lcd.print("    " + timeStamp);
    lastTime = timeStamp;
  }

  // neuer Tag
  if (dayStamp != lastDay) {
    // LCD Display
    lcd.setCursor(0, 1);
    lcd.print("   " + dayStamp);
    lastDay = dayStamp;
  }


  //Uhrzeit auf TFT jede Sekund wg Sekundenzeiger
  if (aktSec != lastSec) {
    // Prüfen om Interupt, wenn ja, neues File
    if ((interrupt == true) || (aktSec == 0)) {
      Ziffercnt = (Ziffercnt + 1) % 4;
      interrupt = false;
      Serial.println((String) "Neues Zifferblatt: " + Ziffercnt + "  --  " + DatenFile[Ziffercnt]);
      Zifferblatt(DatenFile[Ziffercnt]);
    }
    //Zifferblatt(DatenFile);
    // if (FileStat==true) {
    // img.draw(tft, 0, 0);  // Zeichnen Zifferblatt
    // } else {
    tft.fillCircle(120, 120, 77, GC9A01A_WHITE);  // Clear aktiven Bereich
                                                  // }
    ZeigeStd(aktHr, aktMin);
    ZeigeMin(aktMin);
    ZeigeSek(aktSec);
    tft.fillCircle(120, 120, 5, GC9A01A_BLACK);  // Mittelpunkt
    lastSec = aktSec;
  }
}

// **************************************************************************
// Zifferblatt malen
void Zifferblatt(char *Fname) {
  int32_t width, height;
  int status;
  Serial.print(F("Zifferblatt:"));
  Serial.print(Fname);
  //status = reader.loadBMP(Fname, img);  // bmp in Memory
  status = reader.drawBMP(Fname, tft, 0, 0);
  Serial.println((String) "  -- Status:" + status);
  if ((status == IMAGE_SUCCESS) && (FileStat == true)) {
    Serial.println(F("Image loaded successfully (or was clipped fully off screen, still considered successful in that there was no error)"));
    //img.draw(tft, 0, 0);
    return;
  }
  // Bei Fehler Not-Zifferblatt zeichnen
  tft.fillScreen(GC9A01A_LIGHTGREY);
  tft.fillRect(118, 0, 4, 240, GC9A01A_BLACK);
  tft.fillRect(0, 118, 240, 4, GC9A01A_BLACK);
  FileStat = false;

  if (status == IMAGE_ERR_FILE_NOT_FOUND) Serial.println(F("Could not open the requested file (check spelling, confirm file actually exists on the card, make sure it conforms to 8.3 file naming convention (e.g. filename.bmp)"));
  if (status == IMAGE_ERR_FORMAT) Serial.println(F("Not a supported image format. Currently only uncompressed 24-bit color BMPs are supported (more will likely be added over time)"));
  if (status == IMAGE_ERR_MALLOC) Serial.println(F("Could not allocate memory for operation (drawBMP() won t generate this error, but other ImageReader functions might)."));
}
// **************************************************************************
// StundenZeiger
void ZeigeStd(int aHr, int aMin) {
  float Winkel;
  int xmin, xmax, ymin, ymax;
  float sRadius = 55;
  xmin = 120;
  ymin = 120;
  aHr = aHr % 12;  // auf 12 Stunden Normieren
  Winkel = PI / 180 * (180 - ((30 * aHr) + (aMin / 2)));
  xmax = (sRadius * sin(Winkel)) + xmin;
  ymax = (sRadius * cos(Winkel)) + ymin;
  tft.drawLine(xmin, ymin, xmax, ymax, GC9A01A_BLACK);

  tft.drawLine(xmin - 1, ymin, xmax - 1, ymax, GC9A01A_BLACK);
  tft.drawLine(xmin, ymin - 1, xmax, ymax - 1, GC9A01A_BLACK);
  tft.drawLine(xmin + 1, ymin, xmax + 1, ymax, GC9A01A_BLACK);
  tft.drawLine(xmin, ymin + 1, xmax, ymax + 1, GC9A01A_BLACK);

  tft.drawLine(xmin - 2, ymin, xmax - 2, ymax, GC9A01A_BLACK);
  tft.drawLine(xmin, ymin - 2, xmax, ymax - 2, GC9A01A_BLACK);
  tft.drawLine(xmin + 2, ymin, xmax + 2, ymax, GC9A01A_BLACK);
  tft.drawLine(xmin, ymin + 2, xmax, ymax + 2, GC9A01A_BLACK);
}
// **************************************************************************
// MinutenZeiger
void ZeigeMin(int aMin) {
  float Winkel;
  int xmin, xmax, ymin, ymax;
  float sRadius = 75;
  xmin = 120;
  ymin = 120;
  Winkel = PI / 180 * (180 - 6 * aMin);
  xmax = (sRadius * sin(Winkel)) + xmin;
  ymax = (sRadius * cos(Winkel)) + ymin;
  tft.drawLine(xmin, ymin, xmax, ymax, GC9A01A_BLUE);

  tft.drawLine(xmin - 1, ymin, xmax - 1, ymax, GC9A01A_BLUE);
  tft.drawLine(xmin, ymin - 1, xmax, ymax - 1, GC9A01A_BLUE);
  tft.drawLine(xmin + 1, ymin, xmax + 1, ymax, GC9A01A_BLUE);
  tft.drawLine(xmin, ymin + 1, xmax, ymax + 1, GC9A01A_BLUE);

  tft.drawLine(xmin - 2, ymin, xmax - 2, ymax, GC9A01A_BLUE);
  tft.drawLine(xmin, ymin - 2, xmax, ymax - 2, GC9A01A_BLUE);
  tft.drawLine(xmin + 2, ymin, xmax + 2, ymax, GC9A01A_BLUE);
  tft.drawLine(xmin, ymin + 2, xmax, ymax + 2, GC9A01A_BLUE);
}
// **************************************************************************
// MinutenSekunde
void ZeigeSek(int aSek) {
  float Winkel;
  int xmin, xmax, ymin, ymax;
  float sRadius = 77;
  xmin = 120;
  ymin = 120;
  Winkel = PI / 180 * (180 - 6 * aSek);
  xmax = (sRadius * sin(Winkel)) + xmin;
  ymax = (sRadius * cos(Winkel)) + ymin;
  tft.drawLine(xmin, ymin, xmax, ymax, GC9A01A_RED);
}

//*****************************************************************************
// Function to get date and time from NTPClient
void getTimeStamp() {
  int cnt;
  cnt = 0;
  if (WiFiStat == true) {
    while ((!timeClient.update()) && (cnt < 10)) {
      timeClient.forceUpdate();
      cnt++;
    }
    // get Day & Time date
    timeStamp = timeClient.getFormattedTime();
    dayStamp = getFormattedDate();
    //Serial.println(dayStamp + timeStamp);
  } else {
    dayStamp = "xx-xx-xxxx";
    timeStamp = (String)(millis() / 1000);
  }
}

//*****************************************************************
//Timer RTC + NTP
// RTC.-Modul: DS1302

void getRTCtime() {
  Time t = rtc.time();
  // Format the time and date and insert into the temporary buffer.
  char buf1[16];
  char buf2[16];
  //Datum
  snprintf(buf1, sizeof(buf1), "%02d.%02d.%04d",
           t.date, t.mon, t.yr);
  //Zeit
  snprintf(buf2, sizeof(buf2), "%02d:%02d:%02d",
           t.hr, t.min, t.sec);

  dayStamp = buf1;
  timeStamp = buf2;
  aktHr = t.hr;
  aktMin = t.min;
  aktSec = t.sec;
}

//**************************************************************************
void setRTCtime() {
  // Zeit von NTP Client
  if (WiFiStat == true) {
    getTimeStamp();
    getFormattedDate();

    // Initialize a new chip by turning off write protection and clearing the
    // clock halt flag. These methods needn't always be called. See the DS1302
    // datasheet for details.
    rtc.writeProtect(false);
    rtc.halt(false);
    // Make a new time object to set the date and time.
    // Format (int Jahr, int Monat, int Tag, int Stunde, int Minute, int Sekunde , Time::Wochentag)
    Time t(dayStamp.substring(0, 4).toInt(), dayStamp.substring(5, 7).toInt(), dayStamp.substring(8, 10).toInt(),
           timeStamp.substring(0, 2).toInt(), timeStamp.substring(3, 5).toInt(), timeStamp.substring(6, 8).toInt(),
           Time::kSunday);
    // Set the time and date on the chip.
    rtc.time(t);
  }
}

//**************************************************************************
/*String dayAsString(const Time::Day day) {
  switch (day) {
    case Time::kSunday: return "Sunday";
    case Time::kMonday: return "Monday";
    case Time::kTuesday: return "Tuesday";
    case Time::kWednesday: return "Wednesday";
    case Time::kThursday: return "Thursday";
    case Time::kFriday: return "Friday";
    case Time::kSaturday: return "Saturday";
  }
  return "(unknown day)";
}
*/
//**************************************************************************
#define LEAP_YEAR(Y) ((Y > 0) && !(Y % 4) && ((Y % 100) || !(Y % 400)))
String getFormattedDate() {

  unsigned long rawTime = timeClient.getEpochTime() / 86400L;  // in days
  unsigned long days = 0, year = 1970;
  uint8_t month;
  static const uint8_t monthDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

  while ((days += (LEAP_YEAR(year) ? 366 : 365)) <= rawTime)
    year++;
  rawTime -= days - (LEAP_YEAR(year) ? 366 : 365);  // now it is days in this year, starting at 0
  days = 0;
  for (month = 0; month < 12; month++) {
    uint8_t monthLength;
    if (month == 1) {  // february
      monthLength = LEAP_YEAR(year) ? 29 : 28;
    } else {
      monthLength = monthDays[month];
    }
    if (rawTime < monthLength) break;
    rawTime -= monthLength;
  }
  String monthStr = ++month < 10 ? "0" + String(month) : String(month);      // jan is month 1
  String dayStr = ++rawTime < 10 ? "0" + String(rawTime) : String(rawTime);  // day of month
  return String(year) + "-" + monthStr + "-" + dayStr;
}


//**************************************************************************
// Verbinden mit WLAN
bool WiFiConnect() {
  int WiFicnt = 0;
  int Concnt = 0;
  // LED Reset
  digitalWrite(WiFiTrue, LOW);
  digitalWrite(WiFiFalse, HIGH);
  Serial.print(ssid);
  Serial.print(F(" --- "));
  Serial.println(password);
  while ((WiFi.status() != WL_CONNECTED) && (WiFicnt < 10)) {
    WiFicnt++;
    WiFi.begin(ssid, password);
    Concnt = 0;
    while ((WiFi.status() != WL_CONNECTED) && (Concnt < 5)) {
      Concnt++;
      delay(1000);
      Serial.println((String)WiFicnt + "/" + (String)Concnt + ":Connecting to WiFi..");
    }
  }
  if (WiFi.status() == WL_CONNECTED) {
    digitalWrite(WiFiTrue, HIGH);
    digitalWrite(WiFiFalse, LOW);
    return (true);
  } else {
    return (false);
  }
}

/*
//**************************************************************************
//Directory Der SD-Karte
void listDir(fs::FS &fs, const char *dirname, uint8_t levels) {
  Serial.printf("Listing directory: %s\n", dirname);

  File root = fs.open(dirname);
  if (!root) {
    Serial.println("Failed to open directory");
    return;
  }
  if (!root.isDirectory()) {
    Serial.println("Not a directory");
    return;
  }
  File file = root.openNextFile();
  while (file) {
    if (file.isDirectory()) {
      Serial.print("  DIR : ");
      Serial.println(file.name());
      if (levels) {
        listDir(fs, file.name(), levels - 1);
      }
    } else {
      Serial.print("  FILE: ");
      Serial.print(file.name());
      Serial.print("  SIZE: ");
      Serial.println(file.size());
    }
    file = root.openNextFile();
  }
}
*/
