#include <SPI.h>  // SPI für die Kommunikation
#include <SD.h>
#include <FS.h>


// SD Karte
// CS GPIO 5
// MOSI GPIO 23
// CLK  GPIO 18
// MISO GPIO 19
File myFile;
String ConfigFile1 = "/Tresor1.cfg";
String ConfigFile2 = "/Tresor2.cfg";
String ConfigFile;
bool FileStat = false;
// Umschalter Filename
#define CONFIG_PIN 4

// Zeichenvorrat
char Zeichen[128];
// Code Zahlenschloss
char Code[64];
int anzZeichen, anzCode;

// LC-Display
// SDA GPIO 21
// SCL GPIO 22
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);  //LC Display

// Drehschalter
// CLK GPIO 27
// DT  GPIO 26
// SW  GPIO 25
#define CLK_PIN 27
#define DT_PIN 26
#define SW_PIN 25
int SwPos = 0;
int lastSwPos = 0;

// NeoPixel
// PIN 13
#include <Adafruit_NeoPixel.h>
#define PIN1 32
#define NUM_PIXELS 1
#define vel 100  // Velocity in milliseconds
int hell = 100;  // Helligkeit 0...255
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PIN1, NEO_RGB + NEO_KHZ800);

// Servo Motor
// PWM Signal an
// Schloss offen bei 0 Grad
// Schloss zu bei 180 Grad
#include <ESP32Servo.h>
Servo myServo;
#define SERVO_PIN 13
#define SERVO_OPEN 0
#define SERVO_CLOSE 150

// beeper
#define BEEP_PIN 15



/*************************************************************************************/
void setup() {
  int cnt;
  String inhalt;
  Serial.begin(115200);
  delay(200);
  // beeper
  pinMode(BEEP_PIN, OUTPUT);
  digitalWrite(BEEP_PIN, LOW);

  // ConfigFile ermitteln
  pinMode(CONFIG_PIN, INPUT_PULLUP);
  if (digitalRead(CONFIG_PIN) == HIGH) {
    ConfigFile = ConfigFile1;
  } else {
    ConfigFile = ConfigFile2;
  }

  // NeoPixel Start + Farbtest
  strip.begin();
  strip.clear();
  strip.setPixelColor(0, strip.Color(0, hell, 0));
  strip.show();
  delay(500);
  strip.setPixelColor(0, strip.Color(hell, 0, 0));
  strip.show();
  delay(500);
  strip.setPixelColor(0, strip.Color(0, 0, hell));
  strip.show();
  delay(500);

  Serial.println("\nDas Tresorschloss   (hiz10/25)");

  // LC Display 2 Zeilig
  lcd.begin();
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Tresorschloss");
  lcd.setCursor(0, 1);
  lcd.print("HIZ 10/2025");

  // Drehschalter
  pinMode(CLK_PIN, INPUT_PULLUP);
  pinMode(DT_PIN, INPUT_PULLUP);
  pinMode(SW_PIN, INPUT_PULLUP);

  // SD Karte
  FileStat = true;
  Serial.print("Initializing SD card...");
  digitalWrite(5, HIGH);  // SD card chips select, must use GPIO 5 (ESP32 SS)
  delay(1000);

  if (!SD.begin(5)) {
    FileStat = false;
    Serial.println("Fehler Initialisierung!");

  } else {
    Serial.println("SD-Card erfolgreich.");
  }
  uint8_t cardType = SD.cardType();

  if (cardType == CARD_NONE) {
    Serial.println("Keine SD-Karte vorhanden");
    //return;
  }

  Serial.print("SD Karten Type: ");
  if (cardType == CARD_MMC) {
    Serial.println("MMC");
  } else if (cardType == CARD_SD) {
    Serial.println("SDSC");
  } else if (cardType == CARD_SDHC) {
    Serial.println("SDHC");
  } else {
    Serial.println("UNKNOWN");
  }

  uint64_t cardSize = SD.cardSize() / (1024 * 1024);
  Serial.printf("SD Karten Größe: %lluMB\n", cardSize);
  lcd.setCursor(0, 1);
  lcd.print("SD ok          ");

  // Einlesen Konfiguration
  readConfig();
  // Auswerten (Kontrollausgabe)
  Serial.print("Zeichen:");
  lcd.setCursor(0, 0);
  lcd.print(Zeichen);
  lcd.print("          ");
  Serial.println(anzZeichen);
  for (cnt = 0; cnt < anzZeichen; cnt++) {
    Serial.print(Zeichen[cnt]);
  }

  Serial.print("\nCode   :");
  lcd.setCursor(0, 1);
  lcd.print(Code);
  lcd.print("          ");
  Serial.println(anzCode);
  for (cnt = 0; cnt < anzCode; cnt++) {
    Serial.print(Code[cnt]);
  }
  Serial.println();
  // Servo Motor

  myServo.attach(SERVO_PIN);
  myServo.write(SERVO_OPEN);
  delay(1000);
  digitalWrite(BEEP_PIN, HIGH);
  myServo.write(SERVO_CLOSE);
  delay(1000);
  digitalWrite(BEEP_PIN, LOW);
}

/*************************************************************************************/
void loop() {

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Tresorschloss");
  lcd.setCursor(0, 1);

  // Taste drücken zum Start
  lcd.print("Taste druecken");
  Serial.print("Taste Drücken");
  while (digitalRead(SW_PIN) == true)
    ;
  while (digitalRead(SW_PIN) == false)
    ;
  Serial.println(" ok");
  // Schloss zu!
  myServo.write(SERVO_CLOSE);
  delay(300);

  // Vorbereiten für Eingabe
  strip.setPixelColor(0, strip.Color(hell, hell, 0));
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Code eingeben");
  lcd.setCursor(0, 1);
  strip.show();

  // Code Eingabe
  if (Schloss() == true) {
    Serial.println("Offen");
    strip.setPixelColor(0, strip.Color(0, hell, 0));
    strip.show();
    // Schloss auf!
    myServo.write(SERVO_OPEN);

  } else {
    digitalWrite(BEEP_PIN, HIGH);
    Serial.println("Fehleingabe");
    strip.setPixelColor(0, strip.Color(hell, 0, 0));
    strip.show();
    lcd.setCursor(0, 1);

    // Schloss ZU!
    myServo.write(SERVO_CLOSE);
    delay(1000);
    digitalWrite(BEEP_PIN, LOW);
  }
}

/*************************************************************************************/
/* Tresorschloss  Drehschalter seketiert Code immer weiter, wenn gedrückt
*/
bool Schloss() {
  bool dt, clk;
  int position;
  char Eingabe[32];
  // Starten bei Zufallsposition
  SwPos = random(0, anzZeichen);
  lcd.blink();
  lcd.setCursor(0, 1);
  lastSwPos = -1;
  position = 0;
  // Drehschalter bis alle Zeichen eingegeben
  do {
    // Drehschalter einlesen
    dt = digitalRead(DT_PIN);
    clk = digitalRead(CLK_PIN);
    // Warten bis Clock beendet (falls langsam gedreht wird)
    while (digitalRead(CLK_PIN) == false)
      ;

    // Taster gedrückt
    if (digitalRead(SW_PIN) == false) {
      Serial.println("Taster");
      while (digitalRead(SW_PIN) == false)  // Warten bis wieder losgelassen
        ;
      Eingabe[position] = Zeichen[SwPos];  // Zeichen merken
      position++;
      lcd.setCursor(position, 1);
      lcd.print(Zeichen[SwPos]);
      lcd.setCursor(position, 1);
    }

    // Schalter gedreht wenn CLK false
    if (clk == false) {
      // Prüfen ob DT auch false
      if (dt == false) {
        SwPos--;
      } else {
        SwPos++;
      }
      // Prüfen ob kleiner 0 und auf Obergrnze (anzZeichen) begrenzen
      Serial.print(SwPos);
      if (SwPos < 0) SwPos = anzZeichen - 1;
      SwPos = SwPos % anzZeichen;
      Serial.println((String) " -- " + SwPos + " -- " + Zeichen[SwPos]);
    }

    // Drehschalter bewegt - neues Zeichen auf der Posisiton
    if (SwPos != lastSwPos) {
      lastSwPos = SwPos;
      Serial.println(SwPos);
      lcd.setCursor(position, 1);
      lcd.print(Zeichen[SwPos]);
      lcd.setCursor(position, 1);
    }
  } while (position < anzCode);
  // Char Array mit NULL terminieren
  Eingabe[position] = NULL;

  // Eingabe richtig?
  if ((String)Code == (String)Eingabe) {
    lcd.print(" - richtig!");
    dt = true;
  } else {
    lcd.print("- FALSCH!");
    dt = false;
  }
  lcd.noBlink();
  return (dt);
}


/*************************************************************************/
// Einlesen Configfile

/* Einlesen Config File 
   *  
   * Zeichen: Zeichenvorrat
   * Code: Schlosscode

   Vielleicht für Später  aus CO2Ampel-Server V2
   SSID: WLan Name 
   *  PWD: Password, 
   *  SERVER: Name des Web-Servers
    */
void readConfig() {
  String textin;
  String keyword;
  String inhalt;
  int pos;
  int inhlang;

  if (SD.exists(ConfigFile)) {
    myFile = SD.open(ConfigFile, FILE_READ);

    while (myFile.available()) {
      textin = myFile.readStringUntil('\n');
      // Leerzeichen löschen
      textin.replace(" ", "");
      // keyword finden
      pos = textin.indexOf('=');
      if (pos > 0) {
        keyword = textin.substring(0, pos);
        keyword.toUpperCase();
        inhalt = textin.substring(pos + 1);
        Serial.println("key:" + keyword + "  Inhalt:" + inhalt);
        // Zeichenvorrat
        if (keyword == "ZEICHEN") {
          inhlang = inhalt.length();
          inhalt.toCharArray(Zeichen, inhlang);
          anzZeichen = strlen(Zeichen);
        }
        // Code des Schlosses
        if (keyword == "CODE") {
          inhlang = inhalt.length();
          inhalt.toCharArray(Code, inhlang);
          anzCode = strlen(Code);
        }
      }
    }
    myFile.close();
  } else {
    Serial.println("Config File nicht gefunden: " + ConfigFile);
  }
}