//***************************************************************
// Board im Boardverwalter NodeMCU 1.0 (ESP - 12E Module)
//***************************************************************
#include <Adafruit_MPU6050.h>
#include <Adafruit_Sensor.h>
#include <Wire.h>
#include <SPI.h>              // SPI für die Kommunikation
#include <Adafruit_GFX.h>     // Adafruit Grafik-Bibliothek wird benötigt
#include <Adafruit_ST7735.h>  // Adafruit ST7735-Bibliothek wird benötigt
#include <Servo.h>

#define PINTASTER 0  //Pinnummer für den Taster Nodemcuv2 D3 - GPIO0

#define sclk 14  // TFT Display ST7735S = SCK - Nodemcuv2 D5 - GPIO14
#define mosi 13  // TFT Display ST7735S = SOA - Nodemcuv2 D7 - GPIO13
#define cs 15    // TFT Display ST7735S = CS -  Nodemcuv2 D8 - GPIO15
#define dc 2     // TFT Display ST7735S = A0 -  Nodemcuv2 D4 - GPIO2
#define rst -1   // TFT Display ST7735S = RST - Nodemcuv2 RST
// Display
Adafruit_ST7735 tft = Adafruit_ST7735(cs, dc, rst);
// Lagesensor
// SCL  Nodemcuv2 D1 - GPIO55
// SDA  Nodemcuv2 D2 - GPIO 5
Adafruit_MPU6050 mpu;

// Servo Motor
// PWM Signal an Nodemcuv2 D6 - GPIO 12

Servo myServo;
#define SERVO_PIN 12  //  Nodemcuv2 D6 - GPIO 12
#define SERVO_MIN 0
#define SERVO_MAX 180
int SERVO_START = 101;
// Einstellpoti  an Nodemcuv2 A0
#define SERVOPOTI A0

char buff[512];
#define xposW 0
#define yposW 35
#define zposW 70
float Xwert, Ywert, Zwert;
float Xnull, Ynull, Znull = 0;
float lastX, lastY, lastZ;
float ydelta = 0;  // Winkelabweichung

//***************************************************************
//Setup
//***************************************************************
void setup() {
  Serial.begin(9600);

  //Pin für Taster auf Input setzen
  pinMode(PINTASTER, INPUT_PULLUP);

  // TFT-Display Init
  tft.initR(INITR_BLACKTAB);  // Init ST7735S chip
  tft.fillScreen(0);          // Clear screen
  tft.setCursor(0, 0);
  tft.setTextColor(ST7735_WHITE);

  tft.println("Wasserwaagen Test");
  tft.println("HIZ11/25\n");

  // MPU6050 initialisieren
  if (!mpu.begin()) {
    Serial.println("Failed to find MPU6050 chip");
    tft.println("GY-521 ist nicht zu finden");
    while (1) {
      delay(10);
    }
  }
  Serial.println("MPU6050 Found!");
  tft.println("GY-521 gefunden");
  mpu.setAccelerometerRange(MPU6050_RANGE_8_G);
  mpu.setGyroRange(MPU6050_RANGE_500_DEG);
  mpu.setFilterBandwidth(MPU6050_BAND_5_HZ);

  // Servo Motor
  myServo.attach(SERVO_PIN);
  myServo.write(SERVO_START - 30);
  delay(1000);
  myServo.write(SERVO_START + 30);
  delay(1000);
  myServo.write(SERVO_START);
  delay(2000);
  tftStart();
}

//***************************************************************
// Programm Schleife
//***************************************************************
void loop() {

  /* Lesen Sensodaten */
  sensors_event_t a, g, temp;
  mpu.getEvent(&a, &g, &temp);

  // Taste gedrückt -> Nullwerte ermitteln
  if (digitalRead(PINTASTER) == LOW) {
    Serial.println("\nNullpunkt setzen");
    Xnull = a.acceleration.x;
    Ynull = a.acceleration.y;
    Znull = a.acceleration.z;
    // Wenn noch gedrückt das Poti für 90 Grad einstellen
    while (digitalRead(PINTASTER) == LOW) {
      SERVO_START = (analogRead(SERVOPOTI) / 6);
      myServo.write(SERVO_START);
      Serial.println(SERVO_START);
    }
    delay(20);
  }

  // Winkelberechnung
  Xwert = ((a.acceleration.x - Xnull) * 5.93);
  Ywert = ((a.acceleration.y - Ynull) * 5.93);

  // Ausgabe auf TFT Werte und Nukk-Punkt
  // Servo Motor

  if ((abs((lastX - Xwert) > 0.1)) || (abs(lastY - Ywert) > 0.1)) {
    myServo.write(SERVO_START + int((a.acceleration.y - Ynull) * 11.5));
    tftZeichnen();
    tftPrintout();
    lastX = Xwert;
    lastY = Ywert;
  }
}

//***************************************************************
// Init TFT Display
//***************************************************************
void tftStart() {
  tft.fillRect(0, 0, 128, 160, ST7735_BLACK);
  tft.setTextSize(2);
  tft.setCursor(0, xposW);
  tft.print("X-Winkel");
  tft.setCursor(0, yposW);
  tft.print("Y-Winkel");
}

//***************************************************************
// Winkelwerte auf TFT ausgeben
// Löschen und neu schreiben
//***************************************************************
void tftPrintout() {
  int delta = 17;

  tft.setTextColor(ST7735_BLACK);
  tft.setCursor(0, xposW + delta);
  tft.print(lastX);
  tft.setTextColor(ST7735_GREEN);
  tft.setCursor(0, xposW + delta);
  tft.print(Xwert);

  tft.setTextColor(ST7735_BLACK);
  tft.setCursor(0, yposW + delta);
  tft.print(lastY);
  tft.setTextColor(ST7735_RED);
  tft.setCursor(0, yposW + delta);
  tft.print(Ywert);
}

//***************************************************************
// 0-Punkt Zeichnen
//***************************************************************
void tftZeichnen() {
  int Xmitte = 120;
  int Ymitte = 64;
  int xtmp;

  tft.fillRect(0, 80, 128, 160, ST7735_BLUE);
  xtmp = ((Xmitte - Xwert) > 84) ? Xmitte - Xwert : 84;
  tft.fillCircle(Ymitte - Ywert, xtmp, 4, ST7735_GREEN);
  tft.drawCircle(Ymitte, Xmitte, 8, ST7735_WHITE);
}
