/* *********************************************************************
    CO2 Ampel mit WiFi
    hiz 01/2021
 ********************************************************************* */
#include <Adafruit_NeoPixel.h> // RGB LEDs
#include <SPI.h>             // SPI für die Kommunikation
// Libraries to get time from NTP Server
#include <WiFi.h>
#include <NTPClient.h>
#include <WiFiUdp.h>
// RTC clock
#include <DS1302.h>
// 2-Zeilen LCD
#include <LiquidCrystal_I2C.h>

/*
  --- LCD 2 Zeilen Display
    GND   -> GND
    VCC   -> +5V
    SCL   -> G22
    SDA   -> G21
*/

LiquidCrystal_I2C lcd(0x27, 16, 2); // Set the LCD address to 0x27 for a 16 chars and 2 line display

// LEDs
// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PINLED 32
#define NUM_PIXELS  24
#define vel 100 // Velocity in milliseconds

Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PINLED, NEO_RGB + NEO_KHZ400);

//für Farben Neopixel
unsigned long aktcol1;
unsigned long aktcol2;
// Uhrzeit Analoguhr
int stun = 0;
int minu = 0;

// Helligkeitswerte aus Photodiode mit 3,k nach 3.3V
int MaxHell = 4095;
int MinHell = 10;
int HellWert;
#define aLOW 0
#define aHIGH 255
// PhotoDiode ans Pin G35 -> ADC1 CH7
#define PINPHOTO  35

// RTC Modul
const int RT_RSTpin   = 16;  // Chip Enable  RST
const int RT_DATpin   = 13;  // Input/Output DAT
const int RT_CLKpin = 15;  // Serial Clock CLK
// Create a DS1302 object.
DS1302 rtc(RT_RSTpin, RT_DATpin, RT_CLKpin);

unsigned long zeit = 0;

// WLAN Setup
char ssid[64] = "TSS-Fritz\0";
char password[64] = "bagger-112\0";
bool WiFiStat = false;
// LED Definition Pins für rot/grün
#define WiFiTrue 27
#define WiFiFalse 26
// Save reading number on RTC memory
RTC_DATA_ATTR int readingID = 0;
String dataMessage;
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP);

// Variables to save date and time
String formattedDate;
String dayStamp;
String timeStamp;
String lastTime;
String lastDay;
int aktHr, lastHr ;
int aktMin, lastMin;
int aktSec, lastSec;

// **************************************************************************
void setup() {
  int cnt;
  Serial.begin(115200);
  while (!Serial);
  Serial.println("ESP32 - Pseudo-Analoguhr");
  Serial.println ("hiz / 05.2022 / Vers 1.0");
  // WiFiLED
  pinMode(WiFiTrue, OUTPUT);
  pinMode(WiFiFalse, OUTPUT);
  digitalWrite(WiFiTrue, LOW);
  digitalWrite(WiFiFalse, HIGH);

  // LEDs
  strip.begin();
  clearStrip(); // Initialize all pixels to 'off'
  HellWert = aHIGH;
  pinMode (PINPHOTO, INPUT);

  // Init LCD
  lcd.begin();
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("HIZ-Pseudo");
  lcd.setCursor(0, 1);
  lcd.print("Analoguhr");


  Serial.println("initialization done.");

  // Connect to Wi-Fi network with SSID and password
  Serial.println("Connecting to: " + (String)ssid);
  WiFiStat = WiFiConnect();
  if (WiFiStat == true) {
    // Initialize a NTPClient to get time
    timeClient.begin();
    // Set offset time in seconds to adjust for your timezone, for example:
    // GMT +1 = 3600
    // GMT +8 = 28800
    // GMT -1 = -3600
    // GMT 0 = 0
    timeClient.setTimeOffset(7200);
    getTimeStamp();
    Serial.println("Startzeit: " + dayStamp + " " + timeStamp);
    lastTime = timeStamp;
    lastDay = "";
    // Setzen realTime Clock von NTP Server wenn Wifi da
    setRTCtime();

    delay(500);
  }
  // Start
  Serial.println("Inizialisierung fertig");
  delay(1000);
  zeit = 0;
  lastHr = 0;
  lastMin = 0;
}
// **************************************************************************
void loop() {
  int LEDcnt;
  int cnt;
  int i;
  int wert;
  unsigned int HellIn;


  // Datum, Zeit,
  getRTCtime();
  // neue Zeit, also Sekunde
  lastTime = "  ";
  if (timeStamp != lastTime) {
    // Neue Stunde, also RTC setzen
    if (aktHr != lastHr) {
      lastHr = aktHr;
      setRTCtime();
    }
    // LCD Display
    lcd.setCursor(0, 0);
    lcd.print ("    "+timeStamp);
    lastTime = timeStamp;
  }

  // neuer Tag
  if (dayStamp != lastDay) {
    // LCD Display
    lcd.setCursor(0, 1);
    lcd.print("   "+dayStamp);
    lastDay = dayStamp;
  }

  //Uhrzeit auf neopixel jede Ssekund wg. Helligkeit
  if (aktSec != lastSec) {
    lastSec = aktSec;
    //Helligkeit der LEDs berechnen
    HellIn = analogRead(PINPHOTO);
    HellWert = HellIn;
    if (HellWert < MinHell) HellWert = MinHell ;
    if (HellWert > MaxHell) HellWert = MaxHell;
    HellWert = (HellWert - MinHell) * aHIGH / (MaxHell - MinHell) ;
    HellWert = max(HellWert, 8); //  Minimum 8 Hell
    //Serial.println(HellWert);

    aktcol2 = aktMin % 5;
    for (i = 0; i < NUM_PIXELS; i++) {
      strip.setPixelColor(i, 0);
    }

    strip.setPixelColor(((aktHr + 1) % 12) + 12 , NeoFarben(aktHr % 7, HellWert));
    strip.setPixelColor(((aktMin / 5) ) % 12 , NeoFarben(aktcol2, HellWert));
    strip.show();

  }


}

// **************************************************************************
void clearStrip() {
  for ( int i = 0; i < NUM_PIXELS; i++) {
    strip.setPixelColor(i, 0x000000);
    strip.show();
  }
}
//*****************************************************************************
// Function to get date and time from NTPClient
void getTimeStamp() {

  if (WiFiStat == true) {
    while (!timeClient.update()) {
      timeClient.forceUpdate();
    }
    // get Day & Time date
    timeStamp = timeClient.getFormattedTime();
    dayStamp = getFormattedDate();
    //Serial.println(dayStamp + timeStamp);
  } else {
    dayStamp = "xx-xx-xxxx";
    timeStamp = (String)(millis() / 1000);
  }
}

//*****************************************************************
//Timer RTC + NTP

void getRTCtime() {
  Time  t = rtc.time();
  // Format the time and date and insert into the temporary buffer.
  char buf1[16];
  char buf2[16];
  //Datum
  snprintf(buf1, sizeof(buf1), "%02d.%02d.%04d",
           t.date, t.mon, t.yr);
  //Zeit
  snprintf(buf2, sizeof(buf2), "%02d:%02d:%02d",
           t.hr, t.min, t.sec);

  dayStamp = buf1;
  timeStamp = buf2;
  aktHr = t.hr;
  aktMin = t.min;
  aktSec = t.sec;
}

void setRTCtime() {
  // Zeit von NTP Client
  if (WiFiStat == true) {
    getTimeStamp();
    getFormattedDate();

    rtc.writeProtect(false);
    rtc.halt(false);

    // Make a new time object to set the date and time.
    // Format (int Jahr, int Monat, int Tag, int Stunde, int Minute, int Sekunde , Time::Wochentag)
    Time t(dayStamp.substring(0, 4).toInt(), dayStamp.substring(5, 7).toInt(), dayStamp.substring(8, 10).toInt(),
           timeStamp.substring(0, 2).toInt(), timeStamp.substring(3, 5).toInt(), timeStamp.substring(6, 8).toInt(),
           Time::kSunday);
    // Set the time and date on the chip.
    rtc.time(t);
  }
}

String dayAsString(const Time::Day day) {
  switch (day) {
    case Time::kSunday: return "Sunday";
    case Time::kMonday: return "Monday";
    case Time::kTuesday: return "Tuesday";
    case Time::kWednesday: return "Wednesday";
    case Time::kThursday: return "Thursday";
    case Time::kFriday: return "Friday";
    case Time::kSaturday: return "Saturday";
  }
  return "(unknown day)";
}


#define LEAP_YEAR(Y)     ( (Y>0) && !(Y%4) && ( (Y%100) || !(Y%400) ) )
String getFormattedDate() {

  unsigned long rawTime = timeClient.getEpochTime() / 86400L;  // in days
  unsigned long days = 0, year = 1970;
  uint8_t month;
  static const uint8_t monthDays[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

  while ((days += (LEAP_YEAR(year) ? 366 : 365)) <= rawTime)
    year++;
  rawTime -= days - (LEAP_YEAR(year) ? 366 : 365); // now it is days in this year, starting at 0
  days = 0;
  for (month = 0; month < 12; month++) {
    uint8_t monthLength;
    if (month == 1) { // february
      monthLength = LEAP_YEAR(year) ? 29 : 28;
    } else {
      monthLength = monthDays[month];
    }
    if (rawTime < monthLength) break;
    rawTime -= monthLength;
  }
  String monthStr = ++month < 10 ? "0" + String(month) : String(month); // jan is month 1
  String dayStr = ++rawTime < 10 ? "0" + String(rawTime) : String(rawTime); // day of month
  return String(year) + "-" + monthStr + "-" + dayStr ;
}



//    Schalten der Color LEDs alle Farben gleich übergben werden rot, grün blau
void ColorLED(int arot, int agruen, int ablau) {
  int cnt;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(arot, agruen, ablau));
  }
  strip.show();
}

// Verdinden mit WLAN
bool WiFiConnect() {
  int WiFicnt = 0;
  int Concnt = 0;
  // LED Reset
  digitalWrite(WiFiTrue, LOW);
  digitalWrite(WiFiFalse, HIGH);
  Serial.print(ssid);
  Serial.print( " --- ");
  Serial.println(password);
  while ((WiFi.status() != WL_CONNECTED) && (WiFicnt < 10)) {
    WiFicnt++;
    WiFi.begin(ssid, password);
    Concnt = 0;
    while ((WiFi.status() != WL_CONNECTED) && (Concnt < 5)) {
      Concnt++;
      delay(1000);
      Serial.println((String)WiFicnt + "/" + (String)Concnt + ":Connecting to WiFi..");
    }
  }
  if (WiFi.status() == WL_CONNECTED) {
    digitalWrite(WiFiTrue, HIGH);
    digitalWrite(WiFiFalse, LOW);
    return ( true);
  } else {
    return (false);
  }
}

uint32_t NeoFarben(byte WheelPos, int hell) {
  byte state = WheelPos % 7;

  // color(grün, rot blau)
  switch (state) {
    case 0: return strip.Color(0, hell, 0); break;//rot
    case 1: return strip.Color( hell, 0, 0); break; //grün
    case 2: return strip.Color(0, 0, hell); break; //blau
    case 3: return strip.Color(hell, hell, 0); break; //gelb
    case 4: return strip.Color(0, hell, hell); break;//magenta
    case 5: return strip.Color(hell, 0, hell); break; //cyan
    case 6: return strip.Color(hell, hell, hell); break; // weiss
    default: return strip.Color(hell / 2, hell / 2, hell / 2); break;
  }
}
