/* Temp Solar V1.0 HIZ10/22
    Temperatur und Solar (Fronius) gesteuerter Schalter

    Fronius Befehler:
    Freigeben Web-Zugriff:
    http://192.168.17.22/#/solar-api

    Abfrage MeterData
    http://192.168.17.22/solar_api/v1/GetMeterRealtimeData.cgi?Scope=System

     LC-Display
    SDA  D2 ->GPIO5
    SCL  D1 ->GPIO4
  NeoPixel
    D6 -> GPIO12
  Relais
    D5 -> GPIO14

   DS1820 Temperatursensor
	D4 -> GPIO2


*/
#include <Wire.h>
#include <SPI.h>             // SPI für die Kommunikation
#include <ESP8266WiFi.h>
// 2-Zeilen LCD
#include <LiquidCrystal_I2C.h>
// DS1820 Temperatur
#include <OneWire.h>
#include <DallasTemperature.h>
// Neopixel
#include <Adafruit_NeoPixel.h> // RGB LEDs

const char* mySSID =   "SSID";
const char* myPasswd = "PWD";
const char* SolarHost = "xxx.xxx.xxx.xxx";
#define TempMax 23
#define Intervall 30000
unsigned long zeit;
// genug Strom um zu schalten? (negativ, weil inspeisung ins Netz negativ)
#define StromMax -2100
float Strom; //Strom in Watt
int Status; // Status Schalter an/aus

// Pin für Relais Schalter D5 ->GPIO14
#define PINrelais 14

// Neopixel
// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PINLED 12
#define NUM_PIXELS  1
#define vel 100 // Velocity in milliseconds
#define aLOW 0
#define aHIGH 255
int HellWert = 128;
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PINLED, NEO_RGB + NEO_KHZ400);

// Temperatursensor DS1820
// GPIO where the DS18B20 is connected to D4 -> GPIO2
#define ONE_WIRE_BUS 2
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);
DeviceAddress insideThermometer;
float Temperatur;

// Abfrage:
String url = "http://192.168.17.22/solar_api/v1/GetMeterRealtimeData.cgi?Scope=System";
const int httpPort = 80;
WiFiClient client;

LiquidCrystal_I2C lcd(0x27, 16, 2); // Set the LCD address to 0x27 for a 16 chars and 2 line display

void setup() {

  Serial.begin(9600);
  Serial.println("Solar Temperaursteuerung HIZ 10/22");

  // Relais aus
  pinMode(PINrelais, OUTPUT);
  Relais(0); // Relais ausshalten

  // NeoPixel
  strip.begin();
  clearStrip(); // Initialize all pixels to 'off'
  HellWert = aHIGH / 3;
  ColorLED(HellWert, HellWert, HellWert); // LED aus Weiss

  // Init LCD
  lcd.begin();
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("SolarSwitch");
  lcd.setCursor(0, 1);
  lcd.print("hiz 11/2022");

  // Start the DS18B20 sensor
  sensors.begin();

  Serial.print("Found ");
  Serial.print(sensors.getDeviceCount(), DEC);
  Serial.println(" devices.");
  Serial.print("Parasite power is: ");
  if (sensors.isParasitePowerMode()) Serial.println("ON");
  else Serial.println("OFF");
  Serial.print("Device 0 Address: ");
  printAddress(insideThermometer);
  Serial.println();
  sensors.setResolution(insideThermometer, 9);
  Serial.print("Device 0 Resolution: ");
  Serial.print(sensors.getResolution(insideThermometer), DEC);
  Serial.println();


  // WLAN Start
  Serial.print("Connecting to ");
  Serial.println(mySSID);

  WiFi.begin(mySSID, myPasswd);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("\nWiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
  Serial.println();

}

void loop() {
  String line;
  unsigned int lasttime;
  zeit = millis(); // Zeit für Intervall merken
  // Temperatur einlesen
  sensors.requestTemperatures();
  Temperatur = sensors.getTempCByIndex(0);

  // Lesen Status Solar über WiFi

  if (!client.connect(SolarHost, httpPort)) {
    Serial.println("connection failed");
    return;
  }

  //Serial.print("Requesting URL: ");
  //Serial.println(url);

  // This will send the request to the server
  client.print(String("GET ") + url + " HTTP/1.1\r\n" +
               "Host: " + SolarHost + "\r\n" +
               "Connection: close\r\n\r\n");
  // start waiting for the response
  lasttime = millis();
  while (!client.available() && millis() - lasttime < 1000) {
    delay(1); // wait max 1s for data
  }
  // Read all the lines of the reply from server and print them to Serial
  while (client.available()) {
    line = client.readStringUntil('\r');
    /* Leistung ins Netz rausfiltern:
        PowerReal_P_Sum (+ positive) consuming from grid producing power.
        PowerReal_P_Sum (- negative) feeding in to grid normal consumption
    */
    int pos1 = line.indexOf("PowerReal_P_Sum");
    if (( pos1 > 1) && (line.indexOf("Body") > 1 )) {

      //Serial.println ((String) "Position:" +pos1);
      pos1 = line.indexOf(":", pos1) + 1;
      int pos2 = line.indexOf(",", pos1);
      //Serial.println ((String) "Position:" +pos1+ " - " +pos2);
      String line2 = line.substring(pos1, pos2);
      //Serial.print(line);
      Strom = line2.toFloat();
      Serial.print("Stom: ");
      Serial.print(Strom);
      Serial.print (" -- Temp: ");
      Serial.println(Temperatur);
      lcd.clear();
      lcd.setCursor(0, 0);
      lcd.print( (String)Strom +  "W");
      lcd.setCursor(0, 1);
      lcd.print ((String)Temperatur + "C");
      Schalten();
    }
  }
  // bis zum nächsten Intervall
  zeit + Intervall;
  while (millis() <= zeit);

}


void Schalten() {

  // Strom <0 -> es wird ins Netz eingespeist
  // nicht genug Strom
  if (Strom >= 0)  {
    //alles aus
    lcd.setCursor(13, 0);
    lcd.print("Ro ");
    ColorLED(HellWert, 0, 0);
    if (Status != 0) {
      Relais(0);
      Status = 0;
    }
  } else  {
    // genug Strom ins Netz
    if (Strom < StromMax)  {
      // kalt genug?
      if (Temperatur < TempMax)  // es ist kalt genug
      {
        if (Status != 1) {
          Status = 1;
          Relais(1);
          lcd.setCursor(13, 0);
          lcd.print("Gr ");
          ColorLED(0, HellWert, 0);
        }
      } else {
        // Es ist warm genug
        if (Status > 0)
        {
          Status = 0;
          Relais(0);
          lcd.setCursor(13, 0);
          lcd.print("Bl ");
          ColorLED(0, 0, HellWert);
        }
      }
    }
  }
  lcd.setCursor(13, 1);
  if (Status == 1) {
    lcd.print("ein");
  } else {
    lcd.print("aus");
  }
}

// Schalten der Relais stat=1 -> on, Stat=0 ->off
void Relais(int stat) {
  lcd.setCursor(13, 1);
  if (stat == 1) {
    digitalWrite(PINrelais, LOW);
    Serial.println("Relais ein");
    lcd.print("ein");

  } else {
    digitalWrite(PINrelais, HIGH);
    Serial.print ("Relais aus");
    lcd.print("aus");
  }

}
void printAddress(DeviceAddress deviceAddress)
{
  for (uint8_t i = 0; i < 8; i++)
  {
    if (deviceAddress[i] < 16) Serial.print("0");
    Serial.print(deviceAddress[i], HEX);
  }
}

//    Schalten der Color LEDs alle Farben gleich übergben werden rot, grün blau
void ColorLED(int arot, int agruen, int ablau) {
  int cnt;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(arot, agruen, ablau));
  }
  strip.show();
}
void clearStrip() {
  for ( int i = 0; i < NUM_PIXELS; i++) {
    strip.setPixelColor(i, 0x000000);
  }
  strip.show();
}
