/*
   Theremin
   Erster Test mit MCP4725 und VL53L0X
   einz Schmitz 11/2022

   Wiring DA-Wander und TOF-Sensor
        Nano/Uno  Mega  ESP32
   SDA     A4     20    21
   SCL     A5     21    22


   für 2206
   Spannungswert 0...2520
*/
#include <Wire.h>
#include <Adafruit_MCP4725.h>
#include "Adafruit_VL53L0X.h"

Adafruit_VL53L0X lox = Adafruit_VL53L0X();

Adafruit_MCP4725 dac1;

// Analog Input
#define AIN A6

void setup(void) {
  Serial.begin(9600);
  Serial.println("Theremin");


  // For Adafruit MCP4725A1 the address is 0x62 (default) or 0x63 (ADDR pin tied to VCC)
  // For MCP4725A0 the address is 0x60 or 0x61
  // For MCP4725A2 the address is 0x64 or 0x65

  Serial.println("DA-Wandler MCP4725");
  dac1.begin(0x60);
  Serial.println("TOF-Sensor VL53L0X");
  if (!lox.begin()) {
    Serial.println(F("Failed to boot VL53L0X"));
    while (1);
  }


  Serial.println("Los gehts");
}

void loop(void) {
  unsigned int Wert;
  VL53L0X_RangingMeasurementData_t measure;

  lox.rangingTest(&measure, false); // pass in 'true' to get debug data printout!

  if (measure.RangeStatus != 4) {  // phase failures have incorrect data
    //Serial.print("Distance (mm): ");
    Wert = measure.RangeMilliMeter;
    //Serial.print(measure.RangeMilliMeter);
  } else {
    //Serial.print(" out of range ");
    Wert=1001;
  }

   Wert=Wert*2.52;
   if (Wert>2500) Wert=4095;

  Serial.println ((String)"   Wert=" + Wert);
  dac1.setVoltage(Wert, false);
  //delay(10);
}
