// NeoPixel test für Vorlesung
//
// hiz 07/2023
/*
  NeoPixel Strip
  D11 -> GPIO2

  OLED Dieplay
    GND   -> GND
    VCC   -> +5V
    SCL   -> A5
    SDA   -> A4

*/

#include <Adafruit_NeoPixel.h>

#include <math.h>
// OLED
#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
//#include <Adafruit_SSD1306.h>
#include <Adafruit_SH110X.h>


// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PIN1 11
#define NUM_PIXELS  8
#define vel 100 // Velocity in milliseconds
int hell = 100; // Helligkeit 0...255

#define HELL A6
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PIN1, NEO_RGB + NEO_KHZ800);

// Funktionsschalter
#define S1 7
#define S2 2
#define Sfunkt 5

/* OLED Dieplay
    GND   -> GND
    VCC   -> +5V
    SCL   -> A5
    SDA   -> A4
*/
#define i2c_Address 0x3c //initialize with the I2C addr 0x3C Typically eBay OLED's
//#define i2c_Address 0x3d //initialize with the I2C addr 0x3D Typically Adafruit OLED's
#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels
#define OLED_RESET     -1 // Reset pin # (or -1 if sharing Arduino reset pin)

//Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
Adafruit_SH1106G display = Adafruit_SH1106G(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// für HSV nach RGB
struct RGB
{
  unsigned char cR;
  unsigned char cG;
  unsigned char cB;
};

struct HSV
{
  double cH;
  double cS;
  double cV;
};

// LED-Farben
unsigned long LEDcol[8];

// Letzte Helligkeit
int lastHell;

// aktive Funktion
// 1= Logikdemo
//2= Farbwechsel
//3= BinCounter
int funktion;


//*********************************************************************
void setup() {
  int cnt;

  Serial.begin(9600);
  delay(100);
  Serial.println ("Logiktest mit NeoPixel Kette (8 LEDs)");
  Serial.println ("HIZ 8/2023");
  pinMode(S1, INPUT_PULLUP);
  pinMode(S2, INPUT_PULLUP);
  pinMode (Sfunkt, INPUT_PULLUP);
  //OLED Disply
 // if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {// Address 0x3D for 128x64
 //   Serial.println(F("OLED allocation failed"));
 //   for (;;);
//}
delay(250);
  
  display.begin(i2c_Address, true); 
  display.display();
  delay(1000);
  
  display.clearDisplay();
  display.setTextColor(SH110X_WHITE);
  display.setTextSize(3);
  display.setCursor(0, 10);
  // Display static text
  display.print("BinDemo");
  display.setTextSize(1);
  display.setCursor(0, 55);
  display.print("HIZ 08/2023");
  display.display();
//delay(2000);

  strip.begin();
  strip.clear();
  // Farbtest Rot
  hell = analogRead(HELL) / 4;
  lastHell = hell;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor (cnt, strip.Color( 0, hell, 0 ));
    strip.show();
  }
  delay(500);
  // Farbtest Grün
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor (cnt, strip.Color( hell, 0, 0 ));
    strip.show();
  }
  delay(500);
  // Farbtest blau
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor (cnt, strip.Color( 0, 0, hell ));
    strip.show();
  }
  delay(500);

  //alle Pixel an
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    SetPixelCol(cnt, true);
    strip.show();
  }
  delay(1000);
  //alle Pixel aus

  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    SetPixelCol(cnt, false);
  }
  strip.show();
  funktion = 0;
}

//*********************************************************************
void loop() {
  int cnt;
  bool aktS1, aktS2;



  switch (Funktionstest()) {
    case 1:
      //Funkton 1 NanoPixel Farbdemo
      strip.clear();
      strip.show();
      display.clearDisplay();
      display.setTextSize(2);
      display.setCursor(0, 10);
      // Display static text
      display.println("Nano Demo");
      display.display();
      NanoDemo(8);
      break;
    case 2:
      // Funktion 2 =Logikdemo
      strip.clear();
      strip.show();
      display.clearDisplay();
      display.setTextSize(2);
      display.setCursor(0, 10);
      // Display static text
      display.print("Logik Demo");
      display.display();
      LogikDemo();
      break;
    case 3:
      // Funktion 3 =Binär Counter
      strip.clear();
      strip.show();
      display.clearDisplay();
      display.setTextSize(2);
      display.setCursor(0, 10);
      // Display static text
      display.print("BinCount");
      display.display();
      BinCount();
      break;
    default:
      strip.clear();
      strip.show();
      display.clearDisplay();
      display.setTextSize(2);
      display.setCursor(0, 10);
      // Display static text
      display.print("Nix");
      display.display();
      break;
  }
}


//*********************************************************************
void LogikDemo() {

  //letze Schalter
  bool    lastS1 = true;
  bool  lastS2 = false;
  bool lastFF = false;
  bool  Ts1 = false;
  bool  Ts2 = false;
  bool  RSff = false;
  bool aktS1, aktS2;


  do  {
    //invertieren, da gegen 0 geschaltet wird
    aktS1 = !digitalRead(S1);
    aktS2 = !digitalRead(S2);
    hell = analogRead(HELL) ;

    if ((aktS1 != lastS1) || (aktS2 != lastS2) || (abs(lastHell - hell) > 5)) {
      lastS1 = aktS1;
      lastS2 = aktS2;
      lastHell = hell;

      // Taster zu Schalter
      // Umschalt FlipFlop auf S2
      if  (aktS1 == true) {
        Ts1 = !Ts1;
      }
      SetPixelCol(7, Ts1);
      if  (aktS2 == true) {
        Ts2 = !Ts2;
      }
      SetPixelCol(6, Ts2);
      SetPixelCol(0, ((Ts1 == true) && (Ts2 == true))); // And
      SetPixelCol(1, ((Ts1 == true) || (Ts2 == true))); // Or
      SetPixelCol(2, ((Ts1 == false) && (Ts2 == false))); // Nor
      SetPixelCol(3, ((Ts1 == false) || (Ts2 == false))); // Nand
      // RS Flip Flop
      if (aktS1 == true) {
        RSff = true;
      }
      if (aktS2 == true) {
        RSff = false;
      }
      SetPixelCol(5, RSff);
      SetPixelCol(4, false); // immer auf null setzen
      strip.show();
    }
  } while (Funktionstest() == 2);

}

//*********************************************************************
void SetPixelCol(int pixelnr, bool wahr) {
  int Winkel;
  int hell;
  unsigned long color;


  hell = analogRead(HELL) ;
  Winkel = 45 * pixelnr;

  if (wahr == true) {
    if (pixelnr < 6) { // nur die ersten 5 Pixel
      struct HSV cdata = { Winkel, 1.0, (float) hell / 1023.0  };
      struct RGB value = HSVToRGB(cdata);
      color = strip.Color( (int)value.cG, value.cR, value.cB);
    } else {  // Pixel 7 und 8 auf weiss
      color = strip.Color(hell / 3, hell / 3, hell / 3);
    }
  }
  else {
    color = strip.Color( 0, 0, 0);
  }

  //Serial.println((String) " ++ " + pixelnr + "++" + color);
  strip.setPixelColor (7 - pixelnr, color);
}



//*********************************************************************
void NanoDemo (int pixels) {
  int Winkel = 0;
  int cnt;
  int ccnt;
  unsigned long color;
  int schritt = 45;
  unsigned long zeit;

  do  {
    hell = analogRead(HELL);
    for (cnt = 0; cnt < pixels; cnt++) {
      struct HSV cdata = { Winkel, 1.0, (float) hell / 1023 };
      struct RGB value = HSVToRGB(cdata);
      color = strip.Color( value.cG, value.cR, value.cB);
      strip.setPixelColor (cnt, color);
      //strip.show();
      Winkel += schritt;
      if (Winkel > 360) {
        Winkel = 360;
        schritt = -schritt;
      }
      if (Winkel < 0) {
        schritt = -schritt;
        Winkel = 0;
      }
      if (Funktionstest() != 1) return;
    }
    strip.show();
    delay(500);
  } while (Funktionstest() == 1);
}

//*********************************************************************
//Binärcounter
void BinCount() {
  int zahler = -1 ;
  bool  richtung = LOW;
  bool lastpos = LOW;
  int cnt;
  int wert;
  unsigned long color;
  int Winkel;

#define DT 3
#define CLK 4



  do {
    richtung = digitalRead(CLK);
    if ((lastpos == LOW) && (richtung == HIGH)) {
      if (digitalRead(DT) == LOW) {
        zahler--;
      } else {
        zahler++;
      }
      if (zahler < 0) zahler = 255;
      if (zahler > 255) zahler = 0;

      // auf 0 bzw 255 setzen wenn beim drehen S1 oder S2 gedrückt ist
      if (!digitalRead(S1)) zahler = 0;
      if ( !digitalRead(S2)) zahler = 255;
      // Ausgabe auf OLED Dsiplay
      display.clearDisplay();
      display.setTextSize(7);
      display.setCursor(0, 0);
      // Display static text
      if (zahler < 16) {
        display.print("0");
      }
      display.print(zahler, HEX);
      display.setTextSize(2);
      display.setCursor(90, 50);
      display.print(zahler);
      display.display();

      //  In Binär für Neopixel Ausgabe
      for (cnt = 0; cnt < 8; cnt++) {
        wert = (zahler >> cnt) & 1;

        hell = analogRead(HELL) ;
        Winkel = 45 * cnt;

        if (wert > 0) {
          hell = analogRead(HELL) ;
          Winkel = 45 * cnt;
          struct HSV cdata = { Winkel, 1.0, (float) hell / 1023.0  };
          struct RGB value = HSVToRGB(cdata);
          color = strip.Color( (int)value.cG, value.cR, value.cB);
        }   else {
          color = strip.Color( 0, 0, 0);
        }
        strip.setPixelColor ( cnt, color);
      }
      strip.show();
    }
    lastpos = richtung;
  }
  while (Funktionstest() == 3);
}

//*********************************************************************
//Funktionsumschaltung
int Funktionstest() {

  if (!digitalRead(Sfunkt)) {
    while (!digitalRead(Sfunkt)); // gegen prellen
    funktion += 1;
    if (funktion > 3)  funktion = 0;

    display.setCursor(0, 55);
    display.setTextSize( 1);
    // Display static text
    display.print((String) "Funktion: " +  funktion);
    display.display();
  }
  return (funktion);
}

//*********************************************************************
//Farbwinkel 0..360. in RGB 0..255
// https://www.programmingalgorithms.com/algorithm/hsv-to-rgb/c/
/*****Please include following header files*****/
// math.h
/***********************************************/
struct RGB HSVToRGB(struct HSV hsv) {
  double r = 0, g = 0, b = 0;

  if (hsv.cS == 0) {
    r = hsv.cV;
    g = hsv.cV;
    b = hsv.cV;
  }  else  {
    int i;
    double f, p, q, t;

    if (hsv.cH == 360)
      hsv.cH = 0;
    else
      hsv.cH = hsv.cH / 60;

    i = (int)trunc(hsv.cH);
    f = hsv.cH - i;

    p = hsv.cV * (1.0 - hsv.cS);
    q = hsv.cV * (1.0 - (hsv.cS * f));
    t = hsv.cV * (1.0 - (hsv.cS * (1.0 - f)));

    switch (i) {
      case 0:
        r = hsv.cV;
        g = t;
        b = p;
        break;

      case 1:
        r = q;
        g = hsv.cV;
        b = p;
        break;

      case 2:
        r = p;
        g = hsv.cV;
        b = t;
        break;

      case 3:
        r = p;
        g = q;
        b = hsv.cV;
        break;

      case 4:
        r = t;
        g = p;
        b = hsv.cV;
        break;

      default:
        r = hsv.cV;
        g = p;
        b = q;
        break;
    }
  }
  struct RGB rgb;
  rgb.cR = r * 255;
  rgb.cG = g * 255;
  rgb.cB = b * 255;
  return rgb;
}
