// HSV in RGB Umwandeln

// LCD Display adress to 0x27
// LCD SDA -> A4
//     SCL -> A5
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);


// NeoPixel Strip
#include <Adafruit_NeoPixel.h>
// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PIN1 11
#define NUM_PIXELS 44
#define vel 100  // Velocity in milliseconds
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PIN1, NEO_RGB + NEO_KHZ800);

// Poti H - Hue - Farbwinkel
#define Hc A0
// Poti für S - Sättigung
#define Sc A1
// Poti für V - Velocity -. Hell
#define Vc A2
// Zeit seit Systemstart
unsigned long aktzeit;
// Funktionsumschalter
//#define FUNKTION 2
const byte FUNKTION = 2;
volatile byte state = LOW;
int Funktion;

//Datenstrukturen
struct RGB {
  float Rot;
  float Gruen;
  float Blau;
};
struct HSV {
  float Winkel;
  float Satt;
  float Hell;
};

//*************************************************
// Setup System
//*************************************************
void setup() {
  int cnt;
  struct HSV HSVdata;
  struct RGB RGBdata;

  Serial.begin(9600);
  //Headline
  String headline = "HSV->RGB";
  Serial.println(headline);

  // Funktiontaste
  pinMode(FUNKTION, INPUT_PULLUP);
  // Interrupt für Funktionsumschalter
  // InterruptService wird aufgerufen,wenn Taste gedrückt
  attachInterrupt(digitalPinToInterrupt(FUNKTION), InteruptService, FALLING);

  // LC Display 2 Zeilig
  lcd.begin();
  // Backlight on
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(headline);
  lcd.setCursor(0, 1);
  lcd.print("HIZ 2/2025");
  // NeoPixel Init
  strip.begin();
  strip.clear();
  // Farbtest Rot
  HSVdata.Hell = map(analogRead(Vc), 0, 1023, 0, 255);
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, HSVdata.Hell, 0));
    strip.show();
  }
  delay(100);
  // Farbtest Grün
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(HSVdata.Hell, 0, 0));
    strip.show();
  }
  delay(100);
  // Farbtest blau
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, 0, HSVdata.Hell));
    strip.show();
  }

  aktzeit = millis();
  delay(1000);
}

//*************************************************
// Program Loop
//*************************************************
void loop() {
  char buff1[24];
  char buff2[24];
  struct HSV HSVdata;
  struct RGB RGBdata;
  int pixelpos = 0;  // für druchlaufende Farbe

  Funktion = 0;

  // Dauerschleife
  while (1) {

    // Funktionsumschalter

    if (state == HIGH) {
      state = LOW;
      while (digitalRead(FUNKTION) == 0)
        ;  // gegen Prellen
      Funktion = (Funktion + 1) % 3;
      Serial.println("ist low " + (String)Funktion);
      delay(50);  // Anti prellen
    }

    // Funktionmodus
    switch (Funktion) {
      case 0:
        // Winkel fom Regler
        //Serial.println ("Regler aktiv");
        HSVdata.Winkel = map(analogRead(Hc), 0, 1023, 0, 360);
        break;
      case 1:
        // Winkel von 0 bis 360 rundlaufen lasssen
        //Serial.println("automatische Farbwahl");
        HSVdata.Winkel = HSVdata.Winkel + 1;
        if (HSVdata.Winkel > 360)
          HSVdata.Winkel = 0;
        //Serial.println(HSVdata.Winkel);
        break;
      case 2:
        HSVdata.Winkel = HSVdata.Winkel + 7;
        if (HSVdata.Winkel > 360)
          HSVdata.Winkel = 0;
        break;
    }

    // Einlesen Helligkeit und Sättigung
    HSVdata.Hell = map(analogRead(Vc), 0, 1023, 0, 255);
    HSVdata.Satt = map(analogRead(Sc), 0, 1023, 0, 255);

    snprintf(buff1, 24, "H%3d S%3d V%3d", (int)HSVdata.Winkel, (int)HSVdata.Satt, (int)HSVdata.Hell);
    lcd.setCursor(0, 0);
    lcd.print(buff1);

    // Nach RGB konvertieren
    RGBdata = Convert2RGB(HSVdata);

    snprintf(buff2, 24, "R%3d G%3d B%3d", (int)RGBdata.Rot, (int)RGBdata.Gruen, (int)RGBdata.Blau);
    lcd.setCursor(0, 1);
    lcd.print(buff2);
    lcd.setCursor(15, 1);
    lcd.print(Funktion);
    if (Funktion != 2) {
      // Ausgabe auf Strip
      StripOut(RGBdata);
    } else {
      pixelpos++;
      if (pixelpos >= NUM_PIXELS) pixelpos = 0;
      strip.setPixelColor(pixelpos, strip.Color(RGBdata.Gruen, RGBdata.Rot, RGBdata.Blau));
      strip.show();
    }
  }
}

//*************************************************
// konvertieren zu RGB
//*************************************************
struct RGB Convert2RGB(struct HSV HSVdata) {
  float r, g, b;
  struct RGB RGBdata;

  // Berechnen Farbwinkel -> RGB
  // 0-60 Grad - Rot nach Gelb
  if (HSVdata.Winkel <= 60) {
    RGBdata.Rot = HSVdata.Hell;
    RGBdata.Gruen = map(HSVdata.Winkel, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = 0;
  }
  // 60-120 Gelb nach gruen
  if ((HSVdata.Winkel > 60) && (HSVdata.Winkel <= 120)) {
    RGBdata.Rot = HSVdata.Hell - map(HSVdata.Winkel - 60, 0, 60, 0, HSVdata.Hell);
    RGBdata.Gruen = HSVdata.Hell;  //map(HSVdata.Winkel, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = 0;
  }
  // 120-180 gruen nach cyan
  if ((HSVdata.Winkel > 120) && (HSVdata.Winkel <= 180)) {
    RGBdata.Rot = 0;               // HSVdata.Hell - map(HSVdata.Winkel-60, 0, 60, 0, HSVdata.Hell);
    RGBdata.Gruen = HSVdata.Hell;  //map(HSVdata.Winkel, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = map(HSVdata.Winkel - 120, 0, 60, 0, HSVdata.Hell);
  }
  // 180-240 cyan nach blau
  if ((HSVdata.Winkel > 180) && (HSVdata.Winkel <= 240)) {
    RGBdata.Rot = 0;
    RGBdata.Gruen = HSVdata.Hell - map(HSVdata.Winkel - 180, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = HSVdata.Hell;
  }
  // 240-300  blau nach Magenta
  if ((HSVdata.Winkel > 240) && (HSVdata.Winkel <= 300)) {
    RGBdata.Rot = map(HSVdata.Winkel - 240, 0, 60, 0, HSVdata.Hell);
    RGBdata.Gruen = 0;
    RGBdata.Blau = HSVdata.Hell;
  }
  // 300-360  Magenta nach rot
  if (HSVdata.Winkel > 300) {
    RGBdata.Rot = HSVdata.Hell;
    RGBdata.Gruen = 0;
    RGBdata.Blau = HSVdata.Hell - map(HSVdata.Winkel - 300, 0, 60, 0, HSVdata.Hell);
  }
  // Berechnen Sättigung
  float Faktor = (HSVdata.Satt / 255);
  RGBdata.Rot = RGBdata.Rot * Faktor + HSVdata.Hell * (1 - Faktor);
  RGBdata.Gruen = RGBdata.Gruen * Faktor + HSVdata.Hell * (1 - Faktor);
  RGBdata.Blau = RGBdata.Blau * Faktor + HSVdata.Hell * (1 - Faktor);
  return (RGBdata);
}

//*************************************************
// Ausgabe auf Neostrip
//*************************************************
void StripOut(struct RGB RGBdata) {
  int cnt;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(RGBdata.Gruen, RGBdata.Rot, RGBdata.Blau));
  }
  strip.show();
}

//*************************************************
// Interrupt für Funktionsumschalten
//*************************************************
void InteruptService() {
  state = HIGH;
}
