// Thermometer mit MAX6675/DS18B20/DHT11

// LCD Display adress to 0x27
// LCD SDA -> A4
//     SCL -> A5
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);

// DS18B20 Temp Sensor
// Pin 2 mit 4,7k gegen Vcc
#include <OneWire.h>
#include <DallasTemperature.h>
// Data wire is plugged into pin 2 on the Arduino
#define ONE_WIRE_BUS 2
// Setup a OneWire instance to communicate with any OneWire devices
OneWire oneWire(ONE_WIRE_BUS);
// Pass OneWire reference to Dallas Temperature
DallasTemperature sensors(&oneWire);
float lasttemp = -1000;

// K-Termometer mit MAX6675
#include <max6675.h>
int thermoDO = 8;
int thermoCS = 9;
int thermoCLK = 10;
MAX6675 thermocouple(thermoCLK, thermoCS, thermoDO);
#define TempMax 40
#define TempMin -5
float lastkTemp;

// DHT11 Themometer/Luftfeutigkeit
#include <Adafruit_Sensor.h>
#include <DHT.h>
#include <DHT_U.h>
#define DHTPIN 4
#define DHTTYPE DHT11  // DHT 11
DHT_Unified dht(DHTPIN, DHTTYPE);
unsigned long aktzeit;  // Zeit zwischen den Messungen muss 2 Sek betragen
uint32_t delayMS;
sensor_t Sensor;
sensors_event_t event;

// NeoPixel Strip
#include <Adafruit_NeoPixel.h>
// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PIN1 11
#define NUM_PIXELS 44
#define vel 100  // Velocity in milliseconds
int hell = 100;  // Helligkeit 0...255
int lasthell = 100;
// Helligkeitsregelung - Photowiderstand gegen Plus mit 1 kOhm gegen Masse
#define HELL A1
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PIN1, NEO_RGB + NEO_KHZ800);

// Poti zu Temperaturdemo
#define POTI A7
// Funktionen: 0=Poti, 1= DS, 2= MX
#define FUNKTION 13
int funktion;


//*************************************************
// Setup System
//*************************************************
void setup() {
  int cnt;
  Serial.begin(9600);
  //Umschalter für Demo und MX662
  pinMode(FUNKTION, INPUT_PULLUP);
  funktion = 2;  // auf MX Setzen

  //Temp Senor
  sensors.begin();

  // DHT Sensor
  dht.begin();
  delayMS = Sensor.min_delay / 1000;

  // LC Display 2 Zeilig
  lcd.begin();
  // Backlight on
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Temperaturen");
  lcd.setCursor(0, 1);
  lcd.print("HIZ 1.2025");
  // NeoPixel Init
  strip.begin();
  strip.clear();
  // Farbtest Rot
  hell = analogRead(HELL) / 4;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, hell, 0));
    strip.show();
  }
  // Farbtest Grün
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(hell, 0, 0));
    strip.show();
  }
  // Farbtest blau
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, 0, hell));
    strip.show();
  }
  aktzeit = millis();
  delay(1000);
  strip.clear();
  strip.setPixelColor(10, strip.Color(hell, hell, hell));
  strip.show();
}

//*************************************************
// Program Loop
//*************************************************
void loop() {
  float temp;
  float kTemp;
  float humidity;

  String Meldung;

  // Tastenstatus
  if (digitalRead(FUNKTION) == 0) {
    while (digitalRead(FUNKTION) == 0)
      ;  // gegen Prellen
    funktion = (funktion + 1) % 4;
    Serial.println("ist low " + (String)funktion);
    lcd.setCursor(0, 0);
    switch (funktion) {
      case 0:
        lcd.print("Poti         ");
        break;
      case 1:
        lcd.print("DS18B20         ");
        break;
      case 2:
        lcd.print("MAX662      ");
        break;
      case 3:
        lcd.print("DHT11        ");
        break;
    }
    delay(50);  // Anti prellen
  }

  // Temperaturen einlesen
  // Funktionen: 0=Poti, 1= DS, 2= MX
  switch (funktion) {
    case 0:  // Poti
      kTemp = (((float)analogRead(POTI)) / 1024 * NUM_PIXELS) - 3;
      delay(100);
      Meldung = "POTI   : " + (String)kTemp + "    ";
      break;
    case 1:  // DSB1820
      sensors.requestTemperatures();
      kTemp = sensors.getTempCByIndex(0);
      Meldung = "DS Temp: " + (String)kTemp + "        ";
      break;
    case 2:  // MAX6675
      // Warten bis 300 ms um sind
      while (millis() < aktzeit) ;
      aktzeit = millis() +300;
      kTemp = thermocouple.readCelsius();
      Meldung = "MX Temp: " + (String)kTemp + "    ";
      break;
    case 3:  // DHT11
      // Warten bis 200ms um sind
      while (millis() < aktzeit);
      aktzeit = millis() + +delayMS;
      dht.temperature().getEvent(&event);
      if (isnan(event.temperature)) {
        Meldung = "DHT Fehler      ";
      } else {
        Meldung = "DHT Temp: " + (String)event.temperature;
      }
      break;
  }

  hell = analogRead(HELL) / 4;  // Neopixel Helligkeit
  // Nur wenn eine Änderung in Temperatur oder Helligkeit Ausgabe
  if ((lasttemp != temp) || (lastkTemp != kTemp) || (hell != lasthell)) {
    Serial.println("Temperatur: " + (String)temp + " Grad C");
    // letzte Werte Merken
    lasthell = hell;
    lasttemp = temp;
    lastkTemp = kTemp;

    lcd.setCursor(0, 1);
    lcd.print(Meldung + "        ");

    StripOut(kTemp);
  }
}

// Ausgeben Temperatur aur Neostrip
void StripOut(float TempAkt) {
  int anzPixel;
  int cnt;
  uint32_t Scolor;
  int nullWert;
  int Rot, Gruen, Blau;

  // Ermitteln Anzahl Pixel
  anzPixel = (TempAkt - TempMin) * NUM_PIXELS / (TempMax - TempMin);
  nullWert = -TempMin * NUM_PIXELS / (TempMax - TempMin);
  //Serial.print((String)anzPixel + "  ");
  //Serial.println(nullWert);

  // ermitteln Farbe / Grün-rot-blau
  //Über 30 Grad ist Heiss (lila)
  Rot = hell;
  Blau = (TempAkt - 30) * hell / 10;
  Gruen = 0;
  // unter 10 Grad Blau
  if (TempAkt <= 10) {
    Rot = 0;
    Gruen = 0;
    Blau = hell;
  }
  // Zwischen 10 und 20 von Blau nach Grün
  if ((TempAkt > 10) && (TempAkt <= 20)) {
    Rot = 0;
    Blau = (20 - TempAkt) * hell / 10;
    Gruen = (TempAkt - 10) * hell / 10;
  }
  // Zwischen 20 uns 30 Grad  von Grün nach rot
  if ((TempAkt > 20) && (TempAkt <= 30)) {
    Blau = 0;
    Rot = (TempAkt - 20) * hell / 10;
    Gruen = (30 - TempAkt) * hell / 10;
  }
  //Serial.println((String)Rot+" - " +Gruen +" - "+Blau);
  // Setzen Pixel
  Scolor = strip.Color(Gruen, Rot, Blau);
  for (cnt = 0; cnt < anzPixel; cnt++) {
    strip.setPixelColor(cnt, Scolor);
  }
  //Rest auf NeoPixel Strip löschen
  for (cnt = anzPixel; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, 0);
  }

  // Sklala aufbrignen
  // Nullwert markieren
  nullWert = -TempMin * NUM_PIXELS / (TempMax - TempMin);
  strip.setPixelColor(nullWert, strip.Color(hell, hell, hell));
  // 10 Grad (Blau)
  nullWert = 10 - TempMin * NUM_PIXELS / (TempMax - TempMin);
  strip.setPixelColor(nullWert, strip.Color(0, 0, hell));
  // 20 Grad (Grün)
  nullWert = 20 - TempMin * NUM_PIXELS / (TempMax - TempMin);
  strip.setPixelColor(nullWert, strip.Color(hell, 0, 0));
  // 30 Grad (Rot))
  nullWert = 30 - TempMin * NUM_PIXELS / (TempMax - TempMin);
  strip.setPixelColor(nullWert, strip.Color(0, hell, 0));

  strip.show();
}
