// NeoPixel test
//
// hiz 01/2023
/*
  NeoPixel Strip
  Nano   Amica
  D8 -> GPIO2

  Schalter
         Nano Amica
  DIP1 -> 7  GPIO15
  DIP2 -> 6  GPIO13
  DIP3 -> 5  GPIO12
  DIP4 -> 2  GPIO14
*/
/* TFT Display ST7735:
  Pinnung
    Display (Pin) - ESP32
    GND  (1) - GND
    VCC  (2) - 5V
    SCK  (3) - G18
    SDA  (4) - G23
    RES  (5) - G14
    RS/A0(6) - G2
    CS   (7) - G17
    LEDA (8) - 3.3V
    */
#include <SPI.h>       // SPI für die Kommunikation
#include <TFT_eSPI.h>  // Graphics and font library for ST7735 driver chip
#include <Adafruit_NeoPixel.h>

// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PIN1 2
#define NUM_PIXELS 768
//#define NUM_PIXELS2 512
#define vel 100  // Velocity in milliseconds
int hell = 100;  // Helligkeit 0...255
Adafruit_NeoPixel strip1 = Adafruit_NeoPixel(NUM_PIXELS, PIN1, NEO_RGB + NEO_KHZ800);

TFT_eSPI tft = TFT_eSPI();  // Invoke library, pins defined in User_Setup.

// Korrektur der Farbfehler im Include File ST7735.h im 565 (16 Bit) System
#define C_RED 0x001F      //ST7735_BLUE
#define C_BLUE 0xF800     //ST7735_RED
#define C_GREEN 0x07E0    //ST7735_GREEN
#define C_CYAN 0xFFE0     //ST7735_YELLOW
#define C_ORANGE 0x04bf   //ST7735_ORANGE
#define C_MAGENTA 0xF81F  //ST7735_MAGENTA
#define C_YELLOW 0x07FF   //ST7735_CYAN
#define C_WHITE 0xFFFF    //ST7735_WHITE
#define C_BLACK 0x0000    //ST7735_BLACK

// Farben, nur so zum Spass
unsigned int farbe[] = { C_RED, C_GREEN, C_BLUE, C_CYAN, C_ORANGE, C_MAGENTA, C_YELLOW };
int anzFarbe = 6;
int aktFarbe = 0;
int Zeile = 0;  // Zeile auf TFT

// PhotoDiode ans Pin G35 -> ADC1 CH7
const int HELL = 35;
#define FUNKTION 4

int lastfunkt = -1;

// für HSV nach RGB
struct RGB {
  unsigned char cR;
  unsigned char cG;
  unsigned char cB;
};

struct HSV {
  double cH;
  double cS;
  double cV;
};

void setup() {
  int cnt;
  unsigned long color[3];
  int ccnt;

  //Init  Screen
  tft.init();
  tft.setRotation(1);
  tft.fillScreen(C_BLACK);
  tft.setRotation(2);
  // setTextSize(groesse);
  tft.setTextSize(2);
  // setCursor(links,oben);
  tft.setCursor(5, 0);
  // setTextColor(farbe);
  tft.setTextColor(C_WHITE);
  // print(text);
  tft.print("NeoPixel");
  //tft.setTextSize(1);
  tft.setCursor(0, 20);
  tft.println("   Display");
  tft.drawLine(0, 40, 127, 40, C_BLUE);
  tft.setCursor(0, 50);
  tft.setTextSize(2);
  tft.setTextColor(C_GREEN);
  tft.println("Rechts:\n Lauflicht\n");
  tft.setTextColor(C_YELLOW);
  tft.println("Links:\n Waterfall");


  Serial.begin(9600);
  delay(100);
  Serial.println("Lauflichttest mit NeoPixelDisplays (je 256 Pixel)");
  Serial.println("HIZ 6/2025");

  strip1.begin();
  strip1.clear();

  // Farbtest
  pinMode(HELL, INPUT);
  pinMode(FUNKTION, INPUT);
  hell = analogRead(HELL) / 16;

  color[0] = strip1.Color(0, hell, 0);
  color[1] = strip1.Color(hell, 0, 0);
  color[2] = strip1.Color(0, 0, hell);
  for (ccnt = 0; ccnt < 3; ccnt++) {
    for (cnt = 0; cnt < NUM_PIXELS / 3; cnt++) {
      strip1.setPixelColor(cnt, color[ccnt]);
      strip1.setPixelColor(cnt + 256, color[(ccnt + 1) % 3]);
      strip1.setPixelColor(cnt + 512, color[(ccnt + 2) % 3]);
      if ((cnt % 8) == 0) strip1.show();
    }
  }
  strip1.show();
  delay(1000);
}

/*************************************************************/
// Programmschleife
/*************************************************************/
void loop() {

  if (digitalRead(FUNKTION) == 0) {
    Farbspiel();
  } else {
    Waterfall();
  }
}

/*************************************************************/
// Farbspiele von links nach rechts
/*************************************************************/
void Farbspiel() {
  int cnt;
  unsigned int wert;
  int Winkel;
  unsigned long color;
  int schritt = 1;
  int pixels = NUM_PIXELS;

  Winkel = 0;
  while (digitalRead(FUNKTION) == 0) {
    for (cnt = 0; cnt < pixels; cnt++) {
      hell = analogRead(HELL) / 16;
      struct HSV cdata = { Winkel, 1.0, (float)hell / 1023 };
      struct RGB value = HSVToRGB(cdata);
      color = strip1.Color(value.cG, value.cR, value.cB);
      strip1.setPixelColor(cnt, color);
      Winkel += schritt;
      if (Winkel > 360) {
        Winkel = 360;
        schritt = -schritt;
      }
      if (Winkel < 0) {
        schritt = -schritt;
        Winkel = 0;
      }
      if ((cnt % 8) == 0) strip1.show();
    }
    strip1.show();
  }
}

/*************************************************************/
// Waterfall - von oben nach unten
/*************************************************************/
void Waterfall() {
  int cnt;
  int Winkel;
  unsigned long color;
  int schritt = 12;
  int pixels = NUM_PIXELS;
  int PixelNr;
  int Spalte;
  int Zeile;

  Winkel = 0;
  while (digitalRead(FUNKTION)) {
    for (Zeile = 0; Zeile < 8; Zeile++) {
      hell = analogRead(HELL) / 16;
      struct HSV cdata = { Winkel, 1.0, (float)hell / 1023 };
      struct RGB value = HSVToRGB(cdata);
      color = strip1.Color(value.cG, value.cR, value.cB);
      for (Spalte = 0; Spalte < NUM_PIXELS / 8; Spalte++) {

        PixelNr = GetPixel(Spalte, Zeile);
        strip1.setPixelColor(PixelNr, color);
      }
      Winkel += schritt;
      if (Winkel > 360) {
        Winkel = 360;
        schritt = -schritt;
      }
      if (Winkel < 0) {
        schritt = -schritt;
        Winkel = 0;
      }
      strip1.show();
      delay(50);
    }
  }
}

/*************************************************************/
// Spalte und Zeile in Pixelnummer umrechnen
/*************************************************************/
int GetPixel(int Spalte, int Zeile) {
  int Pixel;
  Pixel = Spalte * 8;
  if ((Spalte % 2) == 0) {
    Pixel = Pixel + Zeile;
  } else {
    Pixel = Pixel + (7 - Zeile);
  }
  return (Pixel);
}

/*************************************************************/
//Farbwinkel 0..360. in RGB 0..255
/*************************************************************/
struct RGB HSVToRGB(struct HSV hsv) {
  double r = 0, g = 0, b = 0;

  if (hsv.cS == 0) {
    r = hsv.cV;
    g = hsv.cV;
    b = hsv.cV;
  } else {
    int i;
    double f, p, q, t;

    if (hsv.cH == 360)
      hsv.cH = 0;
    else
      hsv.cH = hsv.cH / 60;

    i = (int)trunc(hsv.cH);
    f = hsv.cH - i;

    p = hsv.cV * (1.0 - hsv.cS);
    q = hsv.cV * (1.0 - (hsv.cS * f));
    t = hsv.cV * (1.0 - (hsv.cS * (1.0 - f)));

    switch (i) {
      case 0:
        r = hsv.cV;
        g = t;
        b = p;
        break;

      case 1:
        r = q;
        g = hsv.cV;
        b = p;
        break;

      case 2:
        r = p;
        g = hsv.cV;
        b = t;
        break;

      case 3:
        r = p;
        g = q;
        b = hsv.cV;
        break;

      case 4:
        r = t;
        g = p;
        b = hsv.cV;
        break;

      default:
        r = hsv.cV;
        g = p;
        b = q;
        break;
    }
  }
  struct RGB rgb;
  rgb.cR = r * 255;
  rgb.cG = g * 255;
  rgb.cB = b * 255;
  return rgb;
}
