// Farbwürfel
//
// hiz 01/2026
/*
  NeoPixel Strip
  Nano   Amica
  D8 -> GPIO2
Helligkeit Neopixels A1
*/
#include <Adafruit_MPU6050.h>
#include <Adafruit_Sensor.h>
#include <Wire.h>
#include <SPI.h>  // SPI für die Kommunikation
#include <Adafruit_NeoPixel.h>


// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PIN1 8
#define NUM_PIXELS 55
#define vel 100  // Velocity in milliseconds
int hell = 100;  // Helligkeit 0...255

//#define Photowiderstand nach 3,3V A1 mit 3,3kOhm nach Masse
#define HELL A1
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PIN1, NEO_RGB + NEO_KHZ800);

// Taster für Reset xyz Werte
#define PINTASTER 5
// Gyroskop GY-521 - MPU6050
// SCL A5
// SDA A4
Adafruit_MPU6050 mpu;
float Xwert, Ywert, Zwert;
float Xnull, Ynull, Znull = 0;
int lastX, lastY, lastZ;


void setup() {
  int cnt;

  Serial.begin(9600);
  delay(100);
  Serial.println("Lichtwürfel mit Lageanzeige");
  Serial.println("HIZ 1/2026");

 //Pinnummer für den Taster Nodemcuv2 D3 - GPIO0
  pinMode(PINTASTER, INPUT_PULLUP);

  strip.begin();
  strip.clear();
  // Farbtest Rot
  hell = analogRead(HELL) / 4;
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, hell, 0));
    strip.show();
  }
  delay(300);
  // Farbtest Grün
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(hell, 0, 0));
    strip.show();
  }
  delay(300);
  // Farbtest blau
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, 0, hell));
    strip.show();
  }
  delay(1000);
   
   // MPU6050 initialisieren
  if (!mpu.begin()) {
    Serial.println("GY-521 ist nicht zu finden");
    while (1) {
      delay(10);
    }
  }
  Serial.println("MGY-521 - PU6050 gefunden!");
  mpu.setAccelerometerRange(MPU6050_RANGE_8_G);
  mpu.setGyroRange(MPU6050_RANGE_500_DEG);
  mpu.setFilterBandwidth(MPU6050_BAND_5_HZ);
  Serial.println("Alles klar, Los gehts!");
  delay(1000);
}

void loop() {
  int cnt;
  int Xled,Yled,Zled;
  /* Lesen Sensodaten */
  sensors_event_t a, g, temp;
  mpu.getEvent(&a, &g, &temp);

  // Taste gedrückt -> Nullwerte ermitteln
  if (digitalRead(PINTASTER) == LOW) {
    Serial.println("\nNullpunkt setzen");
    Xnull = a.acceleration.x;
    Ynull = a.acceleration.y;
    Znull = a.acceleration.z;
    // Wenn noch gedrückt das Poti für 90 Grad einstellen
    while (digitalRead(PINTASTER) == LOW) {
    }
    delay(20);
  }

  // Winkelberechnung
  Xwert = ((a.acceleration.x - Xnull));
  Ywert = ((a.acceleration.y - Ynull));
  Zwert = ((a.acceleration.z - Znull));

  Serial.println((String) "Xwert:" + Xwert + " - Ywert:" + Ywert + " - Zwert=" + Zwert);
  
  float faktor = 50;
  hell = analogRead(HELL) ;
  Xled= (Xwert*hell/faktor);
  Yled= (Ywert*hell/faktor);
  Zled= (Zwert*hell/faktor);
  Serial.println((String) "Xled:" + Xled + " - Ywled:" + Yled + " - Zled=" + Zled);

  // Neopixel schalten
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(abs(Xled), abs(Yled), abs(Zled)));
  }
  strip.show();
  delay(200);
}

